package com.bxm.spider.prod.facade.fallback;

import com.bxm.spider.prod.facade.DownloadFeignService;
import com.bxm.spider.prod.param.DownloadParam;
import com.bxm.spider.response.ResponseModel;
import com.bxm.spider.response.ResponseModelFactory;
import feign.hystrix.FallbackFactory;
import lombok.extern.log4j.Log4j2;
import org.springframework.stereotype.Component;

@Component
@Log4j2
public class DownloadFallbackFactory implements FallbackFactory<DownloadFeignService> {
    @Override
    public DownloadFeignService create(Throwable throwable) {
        return new DownloadFeignService() {
            @Override
            public ResponseModel<Boolean> download(DownloadParam downloadParam) {
                log.error(throwable.getMessage(), throwable);
                return ResponseModelFactory.FAILED();
            }

            @Override
            public ResponseModel<String> pageDownload(String url, boolean isProxy) {
                log.error(throwable.getMessage(), throwable);
                return ResponseModelFactory.FAILED();
            }
        };
    }
}
