package com.bxm.spider.prod.integration.service.impl;

import com.bxm.spider.constant.exception.BaseRunException;
import com.bxm.spider.constant.monitor.ErrorEnum;
import com.bxm.spider.constant.monitor.MonitorConstant;
import com.bxm.spider.constant.monitor.MonitorHelper;
import com.bxm.spider.constant.task.TaskConstant;
import com.bxm.spider.prod.facade.DownloadFeignService;
import com.bxm.spider.prod.param.DownloadParam;
import com.bxm.spider.prod.integration.service.DownLoadIntegrationService;
import com.bxm.spider.response.ResponseModel;
import com.bxm.spider.response.ResponseModelFactory;
import lombok.extern.log4j.Log4j2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 下载服务调用实现
 *
 * @ClassName SpiderDownLoadIntegrationServiceImpl
 * @CopyRright (c) 2018-bxm：杭州微财网络科技有限公司
 * @Author kk.xie
 * @Date 2018/10/22 15:58
 * @Version 1.0
 * @Modifier kk.xie
 * @Modify Date 2018/10/22 15:58
 **/
@Log4j2
@Service
public class DownLoadIntegrationServiceImpl implements DownLoadIntegrationService {

    private Logger logger = LoggerFactory.getLogger(DownLoadIntegrationServiceImpl.class);

    private final DownloadFeignService downloadFeignService;

    @Autowired
    public DownLoadIntegrationServiceImpl(DownloadFeignService downloadFeignService) {
        this.downloadFeignService = downloadFeignService;
    }

    @Override
    public Boolean httpDownLoad(DownloadParam downLoadParam) {
        ResponseModel<Boolean> responseModel = downloadFeignService.download(downLoadParam);
        if (logger.isDebugEnabled()) {
            logger.debug("execute download success params:{}", downLoadParam);
        }
        // 参数错误
        if (null != responseModel && responseModel.isError()) {
            logger.error(MonitorConstant.MONITOR, "调用下载中心失败！downLoadDto: {} {}", downLoadParam, MonitorHelper.ofFailLog(
                    MonitorConstant.PROD_PROGRESS, downLoadParam.getProcessorParameter(), ErrorEnum.PROD_DOWNLOAD_ERROR, ""));
            return false;
        }
        return true;
    }

    @Override
    public Boolean httpDownLoadImage(DownloadParam downLoadParam) {
        ResponseModel<Boolean> responseModel = downloadFeignService.download(downLoadParam);
        if (logger.isDebugEnabled()) {
            logger.debug("execute download success params:{}", downLoadParam);
        }
        // 参数错误
        if (null != responseModel && responseModel.isError()) {
            logger.error("调用下载中心失败！{}", downLoadParam);
            return false;
        }
        return true;
    }
}
