package com.bxm.spider.prod.model.dao;

import com.baomidou.mybatisplus.annotations.TableId;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.IdType;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 过滤规则表
 * </p>
 *
 * @author kk.xie
 * @since 2018-10-18
 */
@TableName("url_ruler")
public class UrlRuler implements Serializable {

    private static final long serialVersionUID = -1357135546690626776L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;
    /**
     * 站点
     */
    private String site;
    /**
     * 规则详情名称
     */
    private String name;
    /**
     * 需要匹配的内容
     */
    private String keyword;
    /**
     * 匹配规则
     */
    private String ruler;
    /**
     * 解析出值的前缀(解析一些特殊url时配置)
     */
    private String prefix;
    /**
     * 替换规则：_:_分割多个需要替换的内容；_=_分割替换体，左边为源内容，右边为替换的新内容
     */
    private String replacement;
    /**
     * 下一页参数名称(根据该参数名称的值+1获取下一页的url地址)
     */
    private String nextPagePara;
    /**
     * 后缀
     */
    private String suffix;
    /**
     * 默认值
     */
    private String defaultValue;
    /**
     * 是否非空(0-否 1-是)
     */
    private Integer emptyFlag;
    /**
     * 父站点地址
     */
    private String parentSite;
    /**
     * 站点前缀(解析一些特殊url时配置)
     */
    private String sitePrefix;
    /**
     * 备注
     */
    private String remark;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 创建人
     */
    private String createUser;
    /**
     * 修改时间
     */
    private Date modifyTime;
    /**
     * 修改人
     */
    private String modifyUser;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getSite() {
        return site;
    }

    public void setSite(String site) {
        this.site = site;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getKeyword() {
        return keyword;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public String getRuler() {
        return ruler;
    }

    public void setRuler(String ruler) {
        this.ruler = ruler;
    }

    public String getPrefix() {
        return prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getReplacement() {
        return replacement;
    }

    public void setReplacement(String replacement) {
        this.replacement = replacement;
    }

    public String getNextPagePara() {
        return nextPagePara;
    }

    public void setNextPagePara(String nextPagePara) {
        this.nextPagePara = nextPagePara;
    }

    public String getSuffix() {
        return suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public String getDefaultValue() {
        return defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public Integer getEmptyFlag() {
        return emptyFlag;
    }

    public void setEmptyFlag(Integer emptyFlag) {
        this.emptyFlag = emptyFlag;
    }

    public String getParentSite() {
        return parentSite;
    }

    public void setParentSite(String parentSite) {
        this.parentSite = parentSite;
    }

    public String getSitePrefix() {
        return sitePrefix;
    }

    public void setSitePrefix(String sitePrefix) {
        this.sitePrefix = sitePrefix;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getCreateUser() {
        return createUser;
    }

    public void setCreateUser(String createUser) {
        this.createUser = createUser;
    }

    public Date getModifyTime() {
        return modifyTime;
    }

    public void setModifyTime(Date modifyTime) {
        this.modifyTime = modifyTime;
    }

    public String getModifyUser() {
        return modifyUser;
    }

    public void setModifyUser(String modifyUser) {
        this.modifyUser = modifyUser;
    }
}
