package com.bxm.spider.constant.monitor;

/**
 * 错误码
 *
 * @ClassName ErrorEnum
 * @CopyRright (c) 2018-bxm：杭州微财网络科技有限公司
 * @Author stephen
 * @Date 2018/11/20 15:22
 * @Version 1.0
 **/
public enum ErrorEnum {
    PROD_ERROR("1000", "调度错误"),
    PROD_DOWNLOAD_ERROR("1001", "调度调用下载错误"),
    DOWNLOAD_ERROR("2000", "下载错误"),
    DOWNLOAD_DEAL_ERROR("2001", "下载调用处理错误"),
    DEAL_ERROR("3000", "处理错误"),
    DEAL_PAGE_INFO_ERROR("3001", "页面内容不符合要求"),
    DEAL_VERIFY_ERROR("3002", "页面内容包含验证码"),
    DEAL_COMMENT_ERROR("3003", "评论解析错误"),
    DEAL_RULER_ERROR("3003", "获取规则出错"),
    SAVE_ERROR("4000", "保存错误"),
    TITLE_EMPTY_ERROR("4001", "保存title为空"),
    CONTENT_EMPTY_ERROR("4002", "保存content为空"),
    SAVE_DUPLICATE_ERROR("4003", "保存重复"),
    OTHER_ERROR("9999", "其他错误"),
    ;

    private String code;
    private String name;

    ErrorEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public String getName() {
        return name;
    }
}
