package com.bxm.spider.constant.processor;

/**
 * <p> 持久化存储器枚举 </p>
 *
 * @Author: JandMin
 * @since: 1.0.0
 * @Date: 2018/11/20
 */
public enum PersistenceEnum {
    /** 新闻 */
    NEWS(1,"NEWS"),
    /** 微信文章 */
    WECHAT(2,"WECHAT"),
    /** 小视频 */
    VIDEO(3,"VIDEO"),
    /** 招聘岗位 */
    WORK(4,"WORK"),
    /** 招聘公司 */
    COMPANY(5,"COMPANY"),
    /** 优惠券*/
    COUPON(6,"COUPON"),
    /** 微信公众号 */
    WECHATACCOUNT(7,"WECHATACCOUNT"),
    /** 微信公众号新闻 */
    WECHATNEWS(8,"WECHATNEWS"),
    /** 视频新闻 */
    NEWSVIDEO(9,"NEWSVIDEO"),
    /** 新闻评论 */
    NEWSCOMMENT(10,"NEWSCOMMENT"),
    /** 小视频视频评论 */
    VIDEOCOMMENT(11,"VIDEOCOMMENT"),
    /** 帖子存储器 */
    FORUM_POST(12,"FORUM_POST"),
    ;

    private Integer code;
    private String name;

    PersistenceEnum(Integer code, String name) {
        this.code = code;
        this.name = name;
    }

    public Integer getCode() {
        return code;
    }

    public String getName() {
        return name;
    }
}
