/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.spider.oss.service.impl;

import com.aliyun.oss.OSSClient;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.model.GetObjectRequest;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PutObjectResult;
import com.bxm.spider.oss.config.AliYunOssProperties;
import com.bxm.spider.oss.enums.FileTypeEnum;
import com.bxm.spider.oss.model.ImageModel;
import com.bxm.spider.oss.service.AliYunOssService;
import com.bxm.spider.utils.DateUtils;
import com.bxm.spider.utils.FileUtils;
import com.bxm.spider.utils.ImageUtils;
import com.bxm.spider.utils.UUIDUtils;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.util.Date;
import java.util.UUID;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
public class AliYunOssServiceImpl
implements AliYunOssService {
    private static final Logger log = LoggerFactory.getLogger(AliYunOssService.class);
    private static final String separator = "/";
    private final String SPIDER_PATH = "/spider/";
    private final String SPIDER_DEFAULT_PATH = "20190101666666/";
    private AliYunOssProperties aliYunOssProperties;

    @Autowired
    public AliYunOssServiceImpl(AliYunOssProperties aliYunOssProperties) {
        this.aliYunOssProperties = aliYunOssProperties;
    }

    public static void main(String[] args) {
        try {
            AliYunOssProperties properties = new AliYunOssProperties();
            AliYunOssServiceImpl ossService = new AliYunOssServiceImpl(properties);
            String url = "http://mmbiz.qpic.cn/mmbiz/uOwWjyzdqadK9gRc2qmsW8KECUXZIicmlxnp0qe0NUdmib29uTgvxaicSyk1jUlRU8k2j8qyoicbdsNbibNjzib8fRRA/0?wx_fmt=jpeg";
            ImageModel image = ossService.getImageInfo(url, "666--", true);
            System.out.println(image);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImageModel getImageInfo(String url, String pathName, boolean isQRCodeEnable) {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpGet httpGet = new HttpGet(url);
        httpGet.addHeader("Content-Type", "application/json");
        httpGet.setConfig(RequestConfig.custom().setSocketTimeout(10000).setConnectTimeout(10000).setConnectionRequestTimeout(10000).build());
        InputStream input = null;
        CloseableHttpResponse response = null;
        try {
            response = httpClient.execute((HttpUriRequest)httpGet);
            HttpEntity httpEntity = response.getEntity();
            byte[] bytes = EntityUtils.toByteArray((HttpEntity)httpEntity);
            String suffix = "-spider";
            if (url.endsWith("gif") || url.endsWith("GIF")) {
                suffix = suffix + ".gif";
            } else if (url.endsWith("jpg") || url.endsWith("JPG")) {
                suffix = suffix + ".jpg";
            } else if (url.endsWith("jpeg") || url.endsWith("JPEG")) {
                suffix = suffix + ".jpg";
            } else if (url.endsWith("png") || url.endsWith("PNG")) {
                suffix = suffix + ".png";
            } else {
                String typeName = this.getTypeFromEntity(httpEntity);
                if (StringUtils.isNotBlank((CharSequence)typeName)) {
                    suffix = suffix + "." + typeName;
                }
            }
            String imgName = UUID.randomUUID() + suffix;
            String path = this.SPIDER_PATH;
            path = StringUtils.isNotBlank((CharSequence)pathName) ? path + pathName + separator : path + "20190101666666/";
            BufferedImage bufferedImage = ImageIO.read(new ByteArrayInputStream(bytes));
            if (null != bufferedImage) {
                boolean isQRCode = ImageUtils.isQRCode((BufferedImage)bufferedImage);
                if (isQRCodeEnable || !isQRCode) {
                    ImageModel imageModel = new ImageModel();
                    imageModel.setQrCode(isQRCode);
                    imageModel.setWidth(bufferedImage.getWidth());
                    imageModel.setHeight(bufferedImage.getHeight());
                    imageModel.setOssUrl(this.upload(bytes, path + imgName));
                    ImageModel imageModel2 = imageModel;
                    return imageModel2;
                }
            }
            ImageModel imageModel = null;
            return imageModel;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (null != input) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    input = null;
                }
            }
            if (null != response) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    response = null;
                }
            }
            if (null != httpClient) {
                try {
                    httpClient.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    httpClient = null;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getOssUrl(String url, String pathName, String compressSuffix) {
        if (StringUtils.isBlank((CharSequence)url)) {
            return "";
        }
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpGet httpGet = new HttpGet(url);
        httpGet.addHeader("Content-Type", "application/json");
        httpGet.setConfig(RequestConfig.custom().setSocketTimeout(10000).setConnectTimeout(10000).setConnectionRequestTimeout(10000).build());
        CloseableHttpResponse response = null;
        try {
            response = httpClient.execute((HttpUriRequest)httpGet);
            HttpEntity entity = response.getEntity();
            String suffix = "";
            if (url.endsWith("gif") || url.endsWith("GIF")) {
                suffix = suffix + ".gif";
            } else if (url.endsWith("jpg") || url.endsWith("JPG")) {
                suffix = suffix + ".jpg";
            } else if (url.endsWith("jpeg") || url.endsWith("JPEG")) {
                suffix = suffix + ".jpg";
            } else if (url.endsWith("png") || url.endsWith("PNG")) {
                suffix = suffix + ".png";
            } else {
                String typeName = this.getTypeFromEntity(entity);
                if (StringUtils.isNotBlank((CharSequence)typeName)) {
                    suffix = suffix + "." + typeName;
                }
            }
            String imgName = UUID.randomUUID() + suffix;
            String path = this.SPIDER_PATH;
            path = StringUtils.isNotBlank((CharSequence)pathName) ? path + pathName + separator : path + "20190101666666/";
            String string = this.upload(entity.getContent(), path + imgName) + compressSuffix;
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (null != response) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    response = null;
                }
            }
            if (null != httpClient) {
                try {
                    httpClient.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    httpClient = null;
                }
            }
        }
        return null;
    }

    @Override
    public String getOssUrl(String url, ImageModel imageModel, String pathName) {
        String suffix = "-spider." + imageModel.getImgType();
        String imgName = UUID.randomUUID() + suffix;
        String path = this.SPIDER_PATH;
        path = StringUtils.isNotBlank((CharSequence)pathName) ? path + pathName + separator : path + "20190101666666/";
        return this.upload(new ByteArrayInputStream(imageModel.getImgByte()), path + imgName);
    }

    private String getTypeFromEntity(HttpEntity entity) {
        String imageType = "";
        String contentType = entity.getContentType().getValue().toLowerCase();
        String[] type = null;
        if (StringUtils.isNotBlank((CharSequence)contentType)) {
            type = contentType.split(separator);
        }
        if (type != null && type.length == 2) {
            imageType = type[1];
        }
        return imageType;
    }

    @Override
    public String[] upload(MultipartFile ... multipartFiles) {
        String[] strings = new String[multipartFiles.length];
        try {
            int i = 0;
            for (MultipartFile multipartFile : multipartFiles) {
                String fileName = multipartFile.getOriginalFilename();
                long contentLength = multipartFile.getSize();
                String contentType = multipartFile.getContentType();
                if (StringUtils.isBlank((CharSequence)contentType)) {
                    contentType = "text/plain";
                }
                String ossPath = this.generateOssPathByFile(fileName);
                PutObjectResult result = this.upload(multipartFile.getInputStream(), contentLength, contentType, ossPath);
                strings[i++] = this.getOSSFileRoot() + ossPath;
            }
        }
        catch (IOException e) {
            log.error("upload multipartFiles error," + e.getMessage(), (Throwable)e);
        }
        return strings;
    }

    @Override
    public String upload(MultipartFile multipartFile) {
        return this.upload(new MultipartFile[]{multipartFile})[0];
    }

    @Override
    public String upload(MultipartFile multipartFile, String path) {
        try {
            long contentLength = multipartFile.getSize();
            String contentType = multipartFile.getContentType();
            if (StringUtils.isBlank((CharSequence)contentType)) {
                contentType = "text/plain";
            }
            String ossPath = this.generateOssPath(path, multipartFile.getOriginalFilename());
            PutObjectResult result = this.upload(multipartFile.getInputStream(), contentLength, contentType, ossPath);
            return this.getOSSFileRoot() + ossPath;
        }
        catch (Exception e) {
            log.error("upload file error:" + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public String[] upload(File ... files) {
        String[] uploadUrlArray = new String[files.length];
        try {
            int i = 0;
            for (File file : files) {
                long contentLength = file.length();
                String suffix = FileUtils.getFileExtension((File)file);
                String contentType = FileTypeEnum.getContentType(suffix);
                if (StringUtils.isBlank((CharSequence)contentType)) {
                    contentType = "text/plain";
                }
                String fileName = file.getName();
                String ossPath = this.generateOssPathByFile(fileName);
                PutObjectResult result = this.upload(new FileInputStream(file), contentLength, contentType, ossPath);
                uploadUrlArray[i++] = this.getOSSFileRoot() + ossPath;
            }
        }
        catch (IOException e) {
            log.error("upload files error", (Throwable)e);
        }
        return uploadUrlArray;
    }

    @Override
    public String upload(File file, String path) {
        try {
            long contentLength = file.length();
            String suffix = FileUtils.getFileExtension((File)file);
            String contentType = FileTypeEnum.getContentType(suffix);
            if (StringUtils.isBlank((CharSequence)contentType)) {
                contentType = "text/plain";
            }
            String ossPath = this.generateOssPath(path, file.getName());
            PutObjectResult result = this.upload(new FileInputStream(file), contentLength, contentType, ossPath);
            return this.getOSSFileRoot() + ossPath;
        }
        catch (Exception e) {
            log.error("upload file error:" + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public String upload(byte[] data, String path) {
        try {
            long contentLength = data.length;
            String contentType = FileTypeEnum.getContentType(StringUtils.substringAfterLast((String)path, (String)"."));
            if (StringUtils.isBlank((CharSequence)contentType)) {
                contentType = "text/plain";
            }
            String ossPath = this.generateOssPathByPath(path);
            PutObjectResult result = this.upload(new ByteArrayInputStream(data), contentLength, contentType, ossPath);
            return this.getOSSFileRoot() + ossPath;
        }
        catch (Exception e) {
            log.error("\u5b57\u8282\u6d41\u4e0a\u4f20\u6587\u4ef6\u53d1\u751f\u9519\u8bef\uff1a" + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public Boolean download(String path, String filePath) {
        try {
            OSSClient ossClient = this.getOssClient();
            if (path.startsWith(separator)) {
                path = path.substring(1);
            }
            path = this.aliYunOssProperties.getFolder() + separator + path;
            GetObjectRequest getObjectRequest = new GetObjectRequest(this.aliYunOssProperties.getBucket(), path);
            ossClient.getObject(getObjectRequest, new File(filePath));
            ossClient.shutdown();
            return true;
        }
        catch (Exception e) {
            log.error("download error", (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String upload(InputStream stream, String path) {
        OSSClient client = this.getOssClient();
        String ossFilePath = this.generateOssPathByPath(path);
        String uploadPath = this.aliYunOssProperties.getFolder() + separator + ossFilePath;
        try {
            PutObjectResult result = client.putObject(this.aliYunOssProperties.getBucket(), uploadPath, stream);
            String string = this.getOSSFileRoot() + ossFilePath;
            return string;
        }
        catch (OSSException oe) {
            oe.printStackTrace();
        }
        finally {
            client.shutdown();
        }
        return "";
    }

    @Override
    public String getOSSFileRoot() {
        if (StringUtils.isNotBlank((CharSequence)this.aliYunOssProperties.getCdnUrl())) {
            return this.aliYunOssProperties.getCdnUrl() + separator + this.aliYunOssProperties.getFolder() + separator;
        }
        return "https://" + this.aliYunOssProperties.getBucket() + "." + this.aliYunOssProperties.getEndpoint() + separator + this.aliYunOssProperties.getFolder() + separator;
    }

    private String generateOssPathByPath(String path) {
        String fileName = this.generateFileNameByPath(path);
        return this.generateOssPath(path, fileName);
    }

    private String generateOssPathByFile(String fileName) {
        if (StringUtils.isNotBlank((CharSequence)fileName)) {
            fileName = UUIDUtils.nextID() + "." + this.generateSuffix(fileName);
        }
        if (StringUtils.isBlank((CharSequence)fileName)) {
            fileName = UUIDUtils.nextID();
        }
        return this.generateOssPath(null, fileName);
    }

    private String generateOssPath(String path, String fileName) {
        if (StringUtils.isBlank((CharSequence)(path = this.handlePath(path)))) {
            path = this.generateDirByFileName(fileName).append(fileName).toString();
            return path;
        }
        if (!path.contains(separator)) {
            path = this.generateDirByFileName(fileName).append(path).toString();
            return path;
        }
        if (path.endsWith(separator)) {
            String suffix = this.generateSuffix(fileName);
            path = path + UUIDUtils.nextID() + "." + suffix;
            return path;
        }
        return path;
    }

    private String handlePath(String path) {
        if (StringUtils.isBlank((CharSequence)path)) {
            return path;
        }
        if ((path = path.replaceAll("\\\\", separator)).startsWith(separator)) {
            path = path.substring(1);
        }
        return path;
    }

    private String generateFileNameByPath(String path) {
        if (StringUtils.isBlank((CharSequence)(path = this.handlePath(path)))) {
            return UUIDUtils.nextID();
        }
        if (!path.contains(separator)) {
            return path;
        }
        if (path.endsWith(separator)) {
            return UUIDUtils.nextID();
        }
        return StringUtils.substringAfterLast((String)path, (String)separator);
    }

    private StringBuilder generateDirByFileName(String fileName) {
        String suffix = this.generateSuffix(fileName);
        String todayStr = ((DateFormat)DateUtils.PATTERN_NO_DELIMITER_FORMAT.get()).format(new Date());
        return new StringBuilder().append(suffix).append(separator).append(todayStr).append(separator);
    }

    private String generateSuffix(String fileName) {
        String suffix = FileUtils.getFilextension((String)fileName);
        String contentType = FileTypeEnum.getContentType(suffix);
        if (StringUtils.isBlank((CharSequence)contentType)) {
            suffix = "txt";
        }
        return suffix;
    }

    private OSSClient getOssClient() {
        return new OSSClient(this.aliYunOssProperties.getEndpoint(), this.aliYunOssProperties.getAccessKey(), this.aliYunOssProperties.getAccessSecret());
    }

    private PutObjectResult upload(InputStream inputStream, long contentLength, String contentType, String path) {
        try {
            ObjectMetadata meta = new ObjectMetadata();
            meta.setContentLength(contentLength);
            meta.setContentType(contentType);
            OSSClient ossClient = this.getOssClient();
            path = this.aliYunOssProperties.getFolder() + separator + path;
            PutObjectResult result = ossClient.putObject(this.aliYunOssProperties.getBucket(), path, inputStream, meta);
            ossClient.shutdown();
            PutObjectResult putObjectResult = result;
            return putObjectResult;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }
}

