package com.bxm.warcar.datasync.autoconfigure.client;

import com.bxm.warcar.datasync.autoconfigure.DataSyncProperties;
import com.bxm.warcar.datasync.client.Action;
import com.bxm.warcar.datasync.client.actions.CacheAction;
import com.bxm.warcar.datasync.client.cache.MutableCache;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * @author allen
 * @date 2019/4/8
 * @since 1.0.0
 */
@Configuration
@ConditionalOnClass(MutableCache.class)
@ConditionalOnProperty(value = DataSyncProperties.PROPERTY_CLIENT, havingValue = "true")
public class ActionAutoConfiguration {

    @Bean
    public Action cacheAction(MutableCache cache) {
        return new CacheAction(cache);
    }
}
