package com.bxm.warcar.datasync.autoconfigure;

import com.bxm.warcar.cache.autoconfigure.jedis.JedisConfiguration;
import com.bxm.warcar.datasync.source.redis.RedisSourceController;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import redis.clients.jedis.JedisPool;

/**
 * @author allen
 * @date 2019/4/8
 * @since 1.0.0
 */
@Configuration
@EnableConfigurationProperties({DataSyncProperties.class, JedisConfiguration.class})
public class SourceControllerAutoConfiguration {

    private final DataSyncProperties dataSyncProperties;
    private final JedisConfiguration jedisConfiguration;

    public SourceControllerAutoConfiguration(DataSyncProperties dataSyncProperties, JedisConfiguration jedisConfiguration) {
        this.dataSyncProperties = dataSyncProperties;
        this.jedisConfiguration = jedisConfiguration;
    }

    @Bean
    public RedisSourceController redisSourceController() {
        DataSyncProperties.Redis redis = dataSyncProperties.getRedis();
        JedisPool jedisPool = new JedisPool(jedisConfiguration, jedisConfiguration.getHost(), jedisConfiguration.getPort(),
                jedisConfiguration.getTimeout(), jedisConfiguration.getPassword(), jedisConfiguration.getDatabase());
        return new RedisSourceController(jedisPool, redis.getPrefix(), redis.getDb());
    }
}
