package com.bxm.warcar.file.autoconfigure;

import com.bxm.warcar.file.upload.HttpFileManager;
import com.bxm.warcar.file.upload.alioss.AliOssHttpFileManager;
import com.bxm.warcar.file.upload.amazon.AmazonHttpFileManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

/**
 * <h3>文件上传配置</h3>
 * <p></p>
 *
 * @author hcmony
 * @since V1.0.0, 2019/01/29 09:50
 */
@EnableConfigurationProperties(HttpFileConfiguration.class)
public class HttpFileAutoConfiguration {

	@Autowired
	private HttpFileConfiguration httpFileConfiguration;

	@Bean
	//@Scope(value = ConfigurableBeanFactory.SCOPE_PROTOTYPE)
	public HttpFileManager httpFileManager() {
		return new AliOssHttpFileManager(httpFileConfiguration.getEndPoint(),
				httpFileConfiguration.getAccessKeyId(),
				httpFileConfiguration.getAccessKeySecret(),
				httpFileConfiguration.getHost(),
				httpFileConfiguration.getBucketName(),
				httpFileConfiguration.getServiceName(),
				httpFileConfiguration.getLimitSize());
	}

    @Bean
    public HttpFileManager amazonHttpFileManager() {
        return new AmazonHttpFileManager(
                httpFileConfiguration.getAccessKeyId(),
                httpFileConfiguration.getAccessKeySecret(),
                httpFileConfiguration.getHost(),
                httpFileConfiguration.getBucketName(),
                httpFileConfiguration.getServiceName(),
                httpFileConfiguration.getLimitSize(),
                httpFileConfiguration.getAmazonRegion());
    }

}
