package com.bxm.warcar.integration.autoconfigure.dc.dot;

import com.bxm.warcar.integration.dc.dot.DotConstants;
import com.bxm.warcar.integration.dc.dot.impl.ThreadPoolExecutorDotImpl;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;

/**
 * @author allen
 * @date 2019/3/7
 * @since 1.0.0
 */
@ConfigurationProperties(prefix = "warcar.integration.dc.dot")
public class DotProperties {

    private String url = DotConstants.DEFAULT_DOT_URL;
    private ThreadPoolProperties threadPool = new ThreadPoolProperties();

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public ThreadPoolProperties getThreadPool() {
        return threadPool;
    }

    public void setThreadPool(ThreadPoolProperties threadPool) {
        this.threadPool = threadPool;
    }

    public static class ThreadPoolProperties {

        private int poolCoreSize = ThreadPoolExecutorDotImpl.DEFAULT_POOL_CORE_SIZE;
        private int awaitTerminationTimeInSeconds = ThreadPoolExecutorDotImpl.DEFAULT_AWAIT_TERMINATION_TIME_IN_SECONDS;

        public int getPoolCoreSize() {
            return poolCoreSize;
        }

        public void setPoolCoreSize(int poolCoreSize) {
            this.poolCoreSize = poolCoreSize;
        }

        public int getAwaitTerminationTimeInSeconds() {
            return awaitTerminationTimeInSeconds;
        }

        public void setAwaitTerminationTimeInSeconds(int awaitTerminationTimeInSeconds) {
            this.awaitTerminationTimeInSeconds = awaitTerminationTimeInSeconds;
        }
    }
}
