package com.bxm.warcar.integration.autoconfigure.distributed;

import com.bxm.warcar.integration.distributed.DistributedLockBeanFactory;
import com.bxm.warcar.integration.distributed.DistributedLockBus;
import com.bxm.warcar.integration.distributed.zk.ZooKeeperDistributedLockBus;
import com.bxm.warcar.zk.ZkClientHolder;
import com.bxm.warcar.zk.autoconfigure.ZkAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;

/**
 * @author allen
 * @since 1.0.0
 */
@ConditionalOnClass({ZkClientHolder.class, ZkAutoConfiguration.class})
@AutoConfigureAfter(ZkAutoConfiguration.class)
public class DistributedScheduledAutoConfiguration {

    @Bean
    @Primary
    @ConditionalOnBean({ZkClientHolder.class, DistributedLockBeanFactory.class})
    public DistributedLockBus zooKeeperDistributedLockBus(DistributedLockBeanFactory distributedLockBeanFactory,
                                                          ZkClientHolder zkClientHolder) {
        return new ZooKeeperDistributedLockBus(distributedLockBeanFactory, zkClientHolder);
    }
}
