package com.bxm.warcar.integration.autoconfigure.eventbus;

import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * @author allen
 * @date 2019/4/26
 * @since 1.0.0
 */
@ConfigurationProperties(prefix = "warcar.integration.eventbus")
public class EventParkProperties {

    private static final int CORE_SIZE = Runtime.getRuntime().availableProcessors() * 2 + 1;

    /**
     * 异步事件总线核心线程数大小
     */
    private int asyncEventBusPoolSize = CORE_SIZE;

    /**
     * 异步事件总线线程池等待终止时间
     */
    private int awaitTerminationSeconds = 30;

    public int getAsyncEventBusPoolSize() {
        return asyncEventBusPoolSize;
    }

    public void setAsyncEventBusPoolSize(int asyncEventBusPoolSize) {
        this.asyncEventBusPoolSize = asyncEventBusPoolSize;
    }

    public int getAwaitTerminationSeconds() {
        return awaitTerminationSeconds;
    }

    public void setAwaitTerminationSeconds(int awaitTerminationSeconds) {
        this.awaitTerminationSeconds = awaitTerminationSeconds;
    }
}
