package com.bxm.warcar.integration.autoconfigure.distributed;

import com.bxm.warcar.integration.distributed.leader.LeaderLatchExecutorBeanFactory;
import com.bxm.warcar.integration.distributed.leader.LeaderSelectorExecutorBeanFactory;
import com.bxm.warcar.zk.ZkClientHolder;
import com.bxm.warcar.zk.autoconfigure.ZkAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;

/**
 * @author Allen Hu
 * @date 2025/10/20
 */
@ConditionalOnClass({ZkClientHolder.class, ZkAutoConfiguration.class})
@AutoConfigureAfter(ZkAutoConfiguration.class)
public class LeaderExecutorAutoConfiguration {

    @Bean
    public LeaderLatchExecutorBeanFactory leaderLatchExecutorBeanFactory(ZkClientHolder zkClientHolder) {
        return new LeaderLatchExecutorBeanFactory(zkClientHolder);
    }

    @Bean
    public LeaderSelectorExecutorBeanFactory leaderSelectorExecutorBeanFactory(ZkClientHolder zkClientHolder) {
        return new LeaderSelectorExecutorBeanFactory(zkClientHolder);
    }
}
