/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.ip.autoconfigure;

import com.bxm.warcar.ip.IpLibrary;
import com.bxm.warcar.ip.autoconfigure.IpLibraries;
import com.bxm.warcar.ip.autoconfigure.IpLibraryConfiguration;
import com.bxm.warcar.ip.impl.BaiduIpLibrary;
import com.bxm.warcar.ip.impl.IpIpNetIpLibrary;
import com.bxm.warcar.utils.file.DataTracker;
import com.bxm.warcar.utils.file.FileComparator;
import com.bxm.warcar.utils.file.FingerprintTracker;
import com.bxm.warcar.utils.file.SimpleDataTracker;
import com.bxm.warcar.utils.file.SimpleFingerprintTracker;
import com.bxm.warcar.utils.file.SystemFileComparator;
import com.bxm.warcar.utils.file.SystemFileComparatorFactory;
import com.bxm.warcar.utils.file.SystemFileMonitor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={IpLibraryConfiguration.class})
public class IpLibraryAutoConfiguration {
    @Autowired
    private IpLibraryConfiguration configuration;

    @Bean(value={"baiduIpLibrary"})
    public BaiduIpLibrary baiduIpLibrary() {
        return new BaiduIpLibrary();
    }

    @Bean(name={"ipIpNetIpLibrary"}, initMethod="init", destroyMethod="destroy")
    public IpIpNetIpLibrary ipIpNetIpLibrary() {
        SystemFileComparator fileComparator = SystemFileComparatorFactory.create().fingerprintTracker((FingerprintTracker)new SimpleFingerprintTracker(this.configuration.getIpipNetFingerprintUrl())).dataTracker((DataTracker)new SimpleDataTracker(this.configuration.getIpipNetDataUrl())).build();
        IpIpNetIpLibrary library = new IpIpNetIpLibrary(fileComparator.getData());
        SystemFileMonitor fileMonitor = new SystemFileMonitor((FileComparator)fileComparator);
        fileMonitor.addListener(() -> ((IpIpNetIpLibrary)library).refresh());
        fileMonitor.start();
        return library;
    }

    @Bean(value={"ipLibraries"})
    public IpLibraries ipLibraries() {
        return new IpLibraries(new IpLibrary[]{this.ipIpNetIpLibrary(), this.baiduIpLibrary()});
    }
}

