/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.ip.autoconfigure;

import com.bxm.warcar.ip.IpLibrary;
import com.bxm.warcar.ip.MatchedIpLibrary;
import com.bxm.warcar.ip.autoconfigure.MatchedIpLibraryConfiguration;
import com.bxm.warcar.ip.impl.SetMatchedIpLibrary;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.springframework.beans.BeansException;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={MatchedIpLibraryConfiguration.class})
public class MatchedIpLibraryAutoConfiguration
implements ApplicationContextAware {
    private final MatchedIpLibraryConfiguration configuration;
    private ApplicationContext applicationContext;

    public MatchedIpLibraryAutoConfiguration(MatchedIpLibraryConfiguration configuration) {
        this.configuration = configuration;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Bean
    public MatchedIpLibrary matchedIpLibrary() throws ClassNotFoundException {
        Object[] classes = this.configuration.getClasses();
        if (ArrayUtils.isEmpty((Object[])classes)) {
            return null;
        }
        ArrayList libraries = Lists.newArrayList();
        for (Object cls : classes) {
            Object bean = this.applicationContext.getBean(Class.forName((String)cls));
            if (null == bean) {
                throw new RuntimeException("Cannot be found class " + (String)cls + " of the application context!");
            }
            if (!(bean instanceof IpLibrary)) {
                throw new RuntimeException("class " + (String)cls + " must be instance of IpLibrary!");
            }
            libraries.add((IpLibrary)bean);
        }
        return new SetMatchedIpLibrary((List)libraries);
    }
}

