package com.bxm.warcar.logging.autoconfigure;

import com.bxm.warcar.logging.support.MongodbLoggingWriter;
import com.mongodb.MongoClient;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.data.mongodb.core.MongoTemplate;

/**
 * @author allen
 * @since 2020-03-19
 */
@ConditionalOnClass({MongoClient.class, MongoTemplate.class})
public class MongodbLoggingWriterAutoConfigure {

    @Bean
    public MongodbLoggingWriter mongodbLoggingWriter(MongoTemplate mongoTemplate) {
        return new MongodbLoggingWriter(mongoTemplate);
    }
}
