package com.bxm.warcar.logging.autoconfigure;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * @author allen
 * @date 2021-07-30
 * @since 1.0
 */
@Data
@ConfigurationProperties(prefix = "aliyun.sls")
public class AliyunLogServiceProperties {

    private String project;
    private String endpoint;
    private String accessKeyId;
    private String accessKeySecret;

    private String logStore;

    /**
     * 是否开启线程池消费
     */
    private boolean enableThreadPool = true;
    /**
     * 线程池核心线程数
     */
    private int coreSize = 20;
}
