/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.message.autoconfigure.email;

import com.bxm.warcar.message.MessageSender;
import com.bxm.warcar.message.autoconfigure.email.EmailProperties;
import com.bxm.warcar.message.email.EmailMessageSender;
import org.apache.commons.lang.StringUtils;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@EnableConfigurationProperties(value={EmailProperties.class})
public class EmailMessageAutoConfiguration {
    private final EmailProperties properties;

    public EmailMessageAutoConfiguration(EmailProperties properties) {
        this.properties = properties;
    }

    @Bean
    public MessageSender emailMessageSender() {
        String host = this.properties.getHost();
        if (StringUtils.isBlank((String)host)) {
            return null;
        }
        return new EmailMessageSender(host, this.properties.getPort(), this.properties.getUsername(), this.properties.getPassword());
    }
}

