package com.bxm.warcar.micrometer.autoconfigure.datasync;

import com.bxm.warcar.datasync.client.cache.Cache;
import com.bxm.warcar.micrometer.datasync.CacheMeter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;

/**
 * @author allen
 * @date 2019/6/20
 * @since 1.0.0
 */
@ConditionalOnBean(Cache.class)
public class CacheMeterAutoConfiguration {

    @Bean
    public CacheMeter cacheMeter(ApplicationContext applicationContext) {
        return new CacheMeter(applicationContext.getBeansOfType(Cache.class).values());
    }
}
