package com.bxm.warcar.mq.autoconfigure.redis;

import com.bxm.warcar.cache.autoconfigure.jedis.JedisConfiguration;
import com.bxm.warcar.mq.Consumer;
import com.bxm.warcar.mq.Listener;
import com.bxm.warcar.mq.Producer;
import com.bxm.warcar.mq.SingleMessageListener;
import com.bxm.warcar.mq.autoconfigure.AbstractSubscriberHandler;
import com.bxm.warcar.mq.redis.JedisPublisher;
import com.bxm.warcar.mq.redis.JedisSubscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import redis.clients.jedis.JedisPool;

/**
 * <h3>广播模式</h3>
 * <p>
 *     发布消息 {@link JedisPublisher}
 *     订阅消息 {@link JedisSubscriber}
 *     注意此方法不支持事务,并且当消息订阅者消费速度慢,会出现问题 。
 * </p>
 *
 * @author hcmony
 * @since V1.0.0, 2020/01/06 09:50
 */
@Configuration
@ConditionalOnClass({JedisPool.class, JedisConfiguration.class})
public class JedisBroadcastingAutoConfiguration extends AbstractSubscriberHandler {

    private static final Logger LOGGER = LoggerFactory.getLogger(JedisBroadcastingAutoConfiguration.class);

    private final JedisPool jedisPool;

    @Autowired
    public JedisBroadcastingAutoConfiguration(JedisPool jedisPool) {
        this.jedisPool = jedisPool;
    }

    @Bean(initMethod = "start", destroyMethod = "close")
    public Producer jedisPublisher() {
        return new JedisPublisher(jedisPool);
    }

    @Override
    protected Consumer create(String consumerId, Listener messageListener) {
        if (!(messageListener instanceof SingleMessageListener)) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("RedisConsumer's message listener must instance of #SingleMessageListener!");
            }
            return null;
        }
        return new JedisSubscriber(jedisPool, (SingleMessageListener) messageListener);
    }
}
