package com.bxm.warcar.mq.autoconfigure.kafka;

import com.bxm.warcar.mq.Consumer;
import com.bxm.warcar.mq.Listener;
import com.bxm.warcar.mq.Producer;
import com.bxm.warcar.mq.autoconfigure.AbstractSubscriberHandler;
import com.bxm.warcar.mq.kafka.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.Properties;

/**
 * @author allen
 * @since 1.0.0
 */
@Configuration
@EnableConfigurationProperties(KafkaProperties.class)
@ConditionalOnClass(KafkaProducer.class)
public class KafkaAutoConfiguration extends AbstractSubscriberHandler {

    private final KafkaProperties properties;

    public KafkaAutoConfiguration(KafkaProperties properties) {
        this.properties = properties;
    }

    @Bean(initMethod = "start", destroyMethod = "close")
    public Producer kafkaProducer() {
        return new com.bxm.warcar.mq.kafka.KafkaProducer(properties.getKafka());
    }

    @Override
    protected Consumer create(String consumerId, Listener messageListener) {
        Properties properties = this.properties.getKafka();
        properties.put("group.id", consumerId);
        return new KafkaConsumer(properties, messageListener);
    }
}
