/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.mq.autoconfigure.redis;

import com.bxm.warcar.cache.autoconfigure.jedis.JedisConfiguration;
import com.bxm.warcar.mq.Producer;
import com.bxm.warcar.mq.redis.JedisProducer;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;
import redis.clients.jedis.JedisPool;

@ConditionalOnClass(value={JedisPool.class, JedisConfiguration.class})
@EnableConfigurationProperties(value={JedisConfiguration.class})
public class JedisAutoConfiguration {
    private final JedisConfiguration jedisConfiguration;

    public JedisAutoConfiguration(JedisConfiguration jedisConfiguration) {
        this.jedisConfiguration = jedisConfiguration;
    }

    @Bean
    @ConditionalOnMissingBean(value={JedisPool.class})
    public JedisPool jedisPool() {
        return new JedisPool((GenericObjectPoolConfig)this.jedisConfiguration, this.jedisConfiguration.getHost(), this.jedisConfiguration.getPort(), this.jedisConfiguration.getTimeout(), this.jedisConfiguration.getPassword(), this.jedisConfiguration.getDatabase());
    }

    @Primary
    @Bean(initMethod="start", destroyMethod="close")
    public Producer jedisProducer() {
        return new JedisProducer(this.jedisPool());
    }
}

