package com.bxm.warcar.mq.autoconfigure.rocketmq;

import com.bxm.warcar.mq.Producer;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.apache.commons.lang.StringUtils;
import org.springframework.boot.context.properties.ConfigurationProperties;

import java.util.List;
import java.util.Map;

/**
 * @author allen
 * @since 1.0.0
 */
@ConfigurationProperties(prefix = "warcar.rocketmq")
public class RocketmqProperties {

    private String nameSrvAddr;
    private String producerGroup = Producer.DEFAULT_PRODUCER_GROUP;
    /**
     * 172.16.10.211:10909 -> 47.97.189.222:10909
     */
    private List<String> brokerAddrAlias = Lists.newArrayList();

    public String getNameSrvAddr() {
        return nameSrvAddr;
    }

    public void setNameSrvAddr(String nameSrvAddr) {
        this.nameSrvAddr = nameSrvAddr;
    }

    public String getProducerGroup() {
        return producerGroup;
    }

    public void setProducerGroup(String producerGroup) {
        this.producerGroup = producerGroup;
    }

    public List<String> getBrokerAddrAlias() {
        return brokerAddrAlias;
    }

    public void setBrokerAddrAlias(List<String> brokerAddrAlias) {
        this.brokerAddrAlias = brokerAddrAlias;
    }

    public Map<String, String> getBrokerAddrAliasMap() {
        String split = "->";
        Map<String, String> map = Maps.newHashMap();
        brokerAddrAlias.forEach(str -> {
            if (StringUtils.isBlank(str)) {
                return;
            }
            String[] strings = StringUtils.split(str, split);
            if (strings.length > 1) {
                map.put(strings[0].trim(), strings[1].trim());
            }
        });
        return map;
    }
}
