package com.bxm.warcar.sentinel.autoconfigure;

import com.alibaba.csp.sentinel.annotation.aspectj.SentinelResourceAspect;
import com.bxm.warcar.sentinel.ZooKeeperDataSourceRegistryFactory;
import com.bxm.warcar.zk.ZkClientHolder;
import com.bxm.warcar.zk.autoconfigure.ZkAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.ConfigurableEnvironment;

/**
 * @author allen
 * @date 2022-03-29
 * @since 1.0
 */
@AutoConfigureAfter(ZkAutoConfiguration.class)
public class SentinelAutoConfiguration {

    @Bean
    public SentinelResourceAspect sentinelResourceAspect() {
        return new SentinelResourceAspect();
    }

    @Bean(initMethod = "init", destroyMethod = "destroy")
    @ConditionalOnBean(ZkClientHolder.class)
    public ZooKeeperDataSourceRegistryFactory sentinelZooKeeperAutoConfiguration(ConfigurableEnvironment environment, ZkClientHolder zkClientHolder) {
        return new ZooKeeperDataSourceRegistryFactory(environment, zkClientHolder);
    }
}
