package com.bxm.warcar.web.interceptor;

import com.bxm.warcar.cache.autoconfigure.jedis.JedisConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import redis.clients.jedis.JedisPool;

/**
 * <h3></h3>
 * <p>
 *      1,使用时必需初始化   @Bean
						 public WebMvcInterceptor webMvcInterceptor(){
						       return new WebMvcInterceptor();
						 }
 *		2,如果想排除一些路径不拦截，请继承此类，重新复写addInterceptors(InterceptorRegistry registry)方法
 *	      @see WebMvcExcludeAliveInterceptor
 *	    3,拦截规则
 *	      @see IpInterceptor
 * </p>
 *
 * @author hcmony
 * @since V1.0.0, 2019/03/07 13:59
 */
public class WebMvcInterceptor extends WebMvcConfigurerAdapter {

	@Autowired
	private JedisConfiguration configuration;

	@Override
	public void addInterceptors(InterceptorRegistry registry) {
		registry.addInterceptor(ipInterceptor()).addPathPatterns("/**");
	}

	@Bean
	public IpInterceptor ipInterceptor(){
		return new IpInterceptor(jedisPool());
	}

	@Bean
	public JedisPool jedisPool() {
		return new JedisPool(configuration, configuration.getHost(), configuration.getPort(), configuration.getTimeout(), configuration.getPassword(), configuration.getDatabase());
	}
}
