package com.bxm.warcar.web.autoconfigure.vision;

import com.bxm.warcar.cache.impls.redis.JedisFetcher;
import com.bxm.warcar.web.autoconfigure.WebProperties;
import com.bxm.warcar.web.autoconfigure.sentinel.JedisSentinelConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import redis.clients.jedis.JedisPool;

/**
 * 幻视系统redis,识别作弊IP,UID库
 *
 * @Author kk.xie
 * @Date 2019/11/25 16:51
 * @Version 1.0
 **/
@Configuration
@EnableConfigurationProperties(JedisVisionConfiguration.class)
public class JedisVisionAutoConfiguration {

    @Autowired
    private JedisVisionConfiguration configuration;

    @Bean
    public JedisPool visionJedisPool() {
        return new JedisPool(configuration, configuration.getHost(), configuration.getPort(), configuration.getTimeout(), configuration.getPassword(), configuration.getDatabase());
    }

    @Bean
    public JedisFetcher visionJedisFetcher() {
        JedisFetcher jedisFetcher = new JedisFetcher(visionJedisPool());
        return jedisFetcher;
    }
}
