package com.bxm.warcar.web.mapping;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

/**
 * <h3>类的基本描述</h3>
 *
 * @author hcmony
 * @since V1.0.0, 2019/8/28 14:16
 */
public enum LocalCache {
    /**
     *
     */
    INSTANCE;

    private LocalMap<String,Long> localMap = new LocalMap<>();
    public AtomicInteger atomicInteger = new AtomicInteger();
    public int count = 1 ;

    public Long get(String key){
       return localMap.get(key);
    }
    public void set(String key,Long value){
        localMap.put(key,value);
    }
    public void incr(String key){
        synchronized (this){
            Long value = localMap.get(key);
            localMap.put(key,null==value?count:value+count);
        }
    }
    public int size(){
       return localMap.size();
    }


    private static class LocalMap<K,V> extends ConcurrentHashMap<K,V>{

        @Override
        public int size() {
            return super.size();
        }

        @Override
        public V get(Object key) {
            return super.get(key);
        }

        @Override
        public V put(K key, V value) {
            return super.put(key, value);
        }
    }

    public static void main(String[] args) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {

        System.out.println(LocalCache.INSTANCE);


        Class<Enum> clazz = (Class<Enum>)Class.forName("com.bxm.warcar.web.mapping.LocalCache");
        Constructor constructor = clazz.getDeclaredConstructor();
        constructor.setAccessible(true);
        Enum enum2 = (Enum) constructor.newInstance();
        System.out.println(enum2);

        Enum[] enumss =  clazz.getEnumConstants();
        for (int i = 0; i < enumss.length; i++) {
            Enum enum1 = enumss[i];
            System.out.println(enum1 +":"+enum1.name());
        }


        Class[] classes = clazz.getDeclaredClasses();
        for (int i = 0; i < classes.length; i++) {
            Class innerClazz = classes[i];
            if (innerClazz.isEnum()){
                String namePath = innerClazz.getSimpleName();
                Class<Enum> enumClazz = (Class<Enum>) Class.forName(namePath);
                Enum[] enums = enumClazz.getEnumConstants();
                for (int j = 0; j <enums.length ; j++) {
                    Enum enum1 = enums[i];
                    System.out.println(enum1 +":"+enum1.name());

                }
            }
        }

    }

}
