package com.bxm.warcar.web.mapping;

import com.bxm.warcar.utils.LifeCycle;
import com.bxm.warcar.utils.NamedThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.concurrent.*;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

/**
 * <h3>类的基本描述</h3>
 *
 * @author hcmony
 * @since V1.0.0, 2019/8/28 11:09
 */
public final class LocalCacheMonitor extends LifeCycle {

    private final static Logger LOGGER = LoggerFactory.getLogger(LocalCacheMonitor.class);
    private final ScheduledExecutorService pool;
    private final LocalCache localCache;
    private final static int THRESHOLD_SIZE = 3;
    private final static AtomicBoolean atomicBoolean = new AtomicBoolean();

    public LocalCacheMonitor() {
        this.localCache = LocalCache.INSTANCE;
        this.pool= new  ScheduledThreadPoolExecutor(4,new NamedThreadFactory("LocalCacheMonitor"));
        init();
    }

    @Override
    protected void doInit() {
        pool.scheduleWithFixedDelay(()->{
            if (localCache.size()>THRESHOLD_SIZE){
                LOGGER.info( "LocalCache size is {} ", localCache.size());
            }
        },10,10, TimeUnit.SECONDS);
    }

    @Override
    protected void doDestroy() {

    }

    public static void main(String[] args) {
        ExecutorService pool = Executors.newScheduledThreadPool(1000);
        AtomicInteger atomicInteger = new AtomicInteger();

        CountDownLatch countDownLatch = new CountDownLatch(10000);
        for (int i = 0; i < 5000000; i++) {
            pool.execute(()->{
                LocalCache.INSTANCE.count+=1;
                synchronized (LocalCacheMonitor.class){
                    atomicInteger.addAndGet(1);
                    LocalCache.INSTANCE.set(atomicInteger.get()+"",0L);
                }
                LocalCache.INSTANCE.atomicInteger.addAndGet(1);
                countDownLatch.countDown();
            });
        }
        try {
            System.out.println("await");
            countDownLatch.await();
        }catch (Exception e){
            e.printStackTrace();
        }

        System.out.println(LocalCache.INSTANCE.atomicInteger);
        System.out.println("size -->"+atomicInteger.get());
        System.out.println(LocalCache.INSTANCE.count);
        System.out.println(LocalCache.INSTANCE.size());
        pool.shutdown();

        try {
            Class.forName("com.bxm.warcar.aspect.mapping");
        }catch ( Exception e){

        }

    }
}
