/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the
 * confidential and proprietary information of bianxianmao.com ("Confidential
 * Information"). You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license agreement you entered
 * into with bianxianmao.com.
 */

package com.bxm.warcar.web.mapping;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.*;

import java.lang.reflect.Method;

/**
 * <h3>环绕日志记录</h3>
 * <p>可能存在问题，如果此方法失败，可能会影响到该方法注解的方法失败</p>
 *
 * @author hcmony
 * @since V1.0.0, 2018/02/07 15:22
 */
@Component
@Aspect
public class MappingAroundAspect{

    private final static Logger logger = LoggerFactory.getLogger(MappingAroundAspect.class);

    @Pointcut("@annotation(org.springframework.web.bind.annotation.RequestMapping) " +
            "|| @annotation(org.springframework.web.bind.annotation.GetMapping) " +
            "|| @annotation(org.springframework.web.bind.annotation.DeleteMapping) " +
            "|| @annotation(org.springframework.web.bind.annotation.PutMapping) " +
            "|| @annotation(org.springframework.web.bind.annotation.PostMapping) "+
            "|| @annotation(org.springframework.web.bind.annotation.PatchMapping) ")
    public void pointcut(){}

    @Around("pointcut()")
    public Object doAround(ProceedingJoinPoint point)throws Throwable{
        long startTime = System.currentTimeMillis();
        String clazz = point.getTarget().getClass().getName();
        Method method = getMethod(point);
        String pathName = getPathMame(method);
        try {
            return point.proceed();
        }finally {
            if (StringUtils.isNoneBlank(pathName)){
                LocalCache.INSTANCE.incr(pathName);
            }
            if ((System.currentTimeMillis()-startTime)>1000){
                logger.info("Excute { {} } time > 1 S ",method);
            }
        }

    }


    private String getPathMame(Method method){
        RequestMapping requestmapping = method.getDeclaredAnnotation(RequestMapping.class);
        if (requestmapping!=null){
            return getPathName(requestmapping.path(),requestmapping.value());
        }

        PutMapping putMapping = method.getDeclaredAnnotation(PutMapping.class);
        if (putMapping!=null){
            return getPathName(putMapping.path(),putMapping.value());
        }

        PostMapping postMapping = method.getDeclaredAnnotation(PostMapping.class);
        if (postMapping!=null){
            return getPathName(postMapping.path(),postMapping.value());
        }

        DeleteMapping deleteMapping = method.getDeclaredAnnotation(DeleteMapping.class);
        if (deleteMapping!=null){
            return getPathName(deleteMapping.path(),deleteMapping.value());
        }

        GetMapping getMapping = method.getDeclaredAnnotation(GetMapping.class);
        if (getMapping!=null){
            return getPathName(getMapping.path(),getMapping.value());
        }

        PatchMapping patchMapping = method.getDeclaredAnnotation(PatchMapping.class);
        if (patchMapping!=null){
            return getPathName(patchMapping.path(),patchMapping.value());
        }
        return null;
    }

    private String getPathName(String[] paths,String[] values){
        if (ArrayUtils.isNotEmpty(paths)){
            return paths[0];
        }
        if (ArrayUtils.isNotEmpty(values)){
            return values[0];
        }
        return null;
    }

    private Method getMethod(JoinPoint point) {
        MethodSignature methodSignature = (MethodSignature) point.getSignature();
        Class<?> targetClass = point.getTarget().getClass();
        try {
            return targetClass.getMethod(methodSignature.getName(), methodSignature.getParameterTypes());
        } catch (NoSuchMethodException e) {
            return null;
        }
    }
}
