/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.web.cache.redis;

import com.bxm.warcar.cache.impls.redis.JedisFetcher;
import com.bxm.warcar.cache.impls.redis.JedisUpdater;
import com.bxm.warcar.web.cache.Cache;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import redis.clients.jedis.JedisPool;

public class RedisCache
implements Cache {
    protected static final String DEFAULT_PAIR_KEY = "warcar:web:cache";
    protected JedisPool jedisPool;
    protected JedisFetcher jedisFetcher;
    protected JedisUpdater jedisUpdater;
    protected String key;

    @Override
    public String get(String key) {
        return this.get0(key);
    }

    @Override
    public Map<String, String> getAll() {
        return this.jedisFetcher.hfetchall(() -> DEFAULT_PAIR_KEY, String.class);
    }

    @Override
    public void set(String key, String value) {
        this.jedisUpdater.hupdate(() -> DEFAULT_PAIR_KEY, key, (Object)value);
    }

    @Override
    public void delete(String key) {
        this.jedisUpdater.hremove(() -> DEFAULT_PAIR_KEY, new String[]{key});
    }

    public String get0(String key) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return null;
        }
        return (String)this.jedisFetcher.hfetch(() -> DEFAULT_PAIR_KEY, key, String.class);
    }
}

