/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.web.interceptor;

import com.bxm.warcar.cache.impls.redis.JedisFetcher;
import com.bxm.warcar.utils.IpHelper;
import com.bxm.warcar.web.autoconfigure.WebProperties;
import com.bxm.warcar.web.bo.PositionMonitorBo;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class IpInterceptor
implements HandlerInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(IpInterceptor.class);
    private static final String RESPONSE_MODEL = "{\"data\":null,\"success\":true,\"error\":false,\"code\":1,\"message\":\"ip\"}";
    private static final String UID = "uid";
    private static final String APPKEY = "appkey";
    private static final String BUSINESS = "business";
    private final WebProperties webProperties;
    private final JedisFetcher sentinelJedisFetcher;
    private final JedisFetcher visionJedisFetcher;

    public IpInterceptor(JedisFetcher sentinelJedisFetcher, JedisFetcher visionJedisFetcher, WebProperties webProperties) {
        this.webProperties = webProperties;
        this.sentinelJedisFetcher = sentinelJedisFetcher;
        this.visionJedisFetcher = visionJedisFetcher;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        try {
            String business;
            if (!this.isOpenFilter()) {
                return true;
            }
            if (this.ignore(request)) {
                return true;
            }
            String ip = StringUtils.defaultIfEmpty((String)IpHelper.getIpFromHeader((HttpServletRequest)request), (String)"");
            String uid = StringUtils.defaultIfEmpty((String)this.getValue(request, UID), (String)"");
            boolean cheatIp = this.checkIpCheat(ip);
            boolean cheatUid = this.checkUidCheat(uid);
            if (!cheatIp && !cheatUid) {
                return true;
            }
            String appkey = StringUtils.defaultIfEmpty((String)this.getValue(request, APPKEY), (String)"");
            boolean monitorPosition = this.checkMonitorPosition(appkey, business = StringUtils.defaultIfEmpty((String)this.getValue(request, BUSINESS), (String)""), cheatIp, cheatUid);
            if (monitorPosition) {
                return true;
            }
            this.write(response);
            return false;
        }
        catch (Exception e) {
            LOGGER.error(" Resolving IP exceptions !", (Throwable)e);
            return true;
        }
    }

    private boolean ignore(HttpServletRequest request) {
        WebProperties.Ip ip = this.webProperties.getIp();
        if (null == ip) {
            return false;
        }
        Map<String, Set<String>> ignoreParameters = ip.getIgnoreParameters();
        if (MapUtils.isNotEmpty(ignoreParameters)) {
            for (Map.Entry<String, Set<String>> entry : ignoreParameters.entrySet()) {
                String key = entry.getKey();
                String pvalue = request.getParameter(key);
                if (!entry.getValue().contains(pvalue)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkMonitorPosition(String appkey, String business, boolean cheatIp, boolean cheatUid) {
        PositionMonitorBo all;
        String position = appkey + business.replaceAll("money|ad", "");
        PositionMonitorBo positionMonitorBo = (PositionMonitorBo)this.sentinelJedisFetcher.hfetch(() -> "AD:CHEAT:MONITOR:POSITION", position, PositionMonitorBo.class);
        if (Objects.nonNull(positionMonitorBo)) {
            Set monitorGranularitySet = positionMonitorBo.getSet(PositionMonitorBo.MonitorEnum.MONITOR_GRANULARITY);
            if (monitorGranularitySet.contains("IP") && cheatIp) {
                return true;
            }
            if (monitorGranularitySet.contains("UID") && cheatUid) {
                return true;
            }
        }
        if (Objects.nonNull(all = (PositionMonitorBo)this.sentinelJedisFetcher.hfetch(() -> "AD:CHEAT:MONITOR:POSITION", "ALL", PositionMonitorBo.class))) {
            Set<PositionMonitorBo.MonitorEnum> processMode = all.getProcessMode();
            if (CollectionUtils.isEmpty(processMode)) {
                return false;
            }
            if (processMode.size() == 1 && processMode.contains((Object)PositionMonitorBo.MonitorEnum.MONITOR_GRANULARITY)) {
                return false;
            }
            Set monitorGranularitySet = all.getSet(PositionMonitorBo.MonitorEnum.MONITOR_GRANULARITY);
            if (monitorGranularitySet.contains("IP") && cheatIp) {
                return true;
            }
            if (monitorGranularitySet.contains("UID") && cheatUid) {
                return true;
            }
        }
        return false;
    }

    private boolean checkUidCheat(String uid) {
        Object o = this.visionJedisFetcher.fetch(() -> StringUtils.join((Object[])new String[]{"CHEAT", "UID", uid}, (String)":"), Object.class);
        return Objects.nonNull(o);
    }

    private boolean checkIpCheat(String ip) {
        Object o = this.visionJedisFetcher.fetch(() -> StringUtils.join((Object[])new String[]{"CHEAT", "IP", ip}, (String)":"), Object.class);
        return Objects.nonNull(o);
    }

    private String getValue(HttpServletRequest request, String key) {
        String value = request.getParameter(key);
        return value;
    }

    private boolean isOpenFilter() {
        Boolean isOpenFilter = (Boolean)this.sentinelJedisFetcher.fetch(() -> "AD:CHEAT:FLOW:FILTER:OPTION", Boolean.class);
        return Boolean.TRUE.equals(isOpenFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(HttpServletResponse response) {
        PrintWriter writer = null;
        try {
            writer = response.getWriter();
            response.setStatus(200);
            writer.print(RESPONSE_MODEL);
            writer.flush();
        }
        catch (IOException e) {
            LOGGER.error(" Resolving IP write !", (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Writer)writer);
        }
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
    }
}

