/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.web.mapping;

import com.bxm.warcar.utils.LifeCycle;
import com.bxm.warcar.utils.NamedThreadFactory;
import com.bxm.warcar.web.mapping.LocalCache;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LocalCacheMonitor
extends LifeCycle {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalCacheMonitor.class);
    private final ScheduledExecutorService pool;
    private final LocalCache localCache = LocalCache.INSTANCE;
    private static final int THRESHOLD_SIZE = 3;
    private static final AtomicBoolean atomicBoolean = new AtomicBoolean();

    public LocalCacheMonitor() {
        this.pool = new ScheduledThreadPoolExecutor(4, (ThreadFactory)new NamedThreadFactory("LocalCacheMonitor"));
        this.init();
    }

    protected void doInit() {
        this.pool.scheduleWithFixedDelay(() -> {
            if (this.localCache.size() > 3) {
                LOGGER.info("LocalCache size is {} ", (Object)this.localCache.size());
            }
        }, 10L, 10L, TimeUnit.SECONDS);
    }

    protected void doDestroy() {
    }

    public static void main(String[] args) {
        ScheduledExecutorService pool = Executors.newScheduledThreadPool(1000);
        AtomicInteger atomicInteger = new AtomicInteger();
        CountDownLatch countDownLatch = new CountDownLatch(10000);
        for (int i = 0; i < 5000000; ++i) {
            pool.execute(() -> {
                ++LocalCache.INSTANCE.count;
                Class<LocalCacheMonitor> clazz = LocalCacheMonitor.class;
                synchronized (LocalCacheMonitor.class) {
                    atomicInteger.addAndGet(1);
                    LocalCache.INSTANCE.set(atomicInteger.get() + "", 0L);
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    LocalCache.INSTANCE.atomicInteger.addAndGet(1);
                    countDownLatch.countDown();
                    return;
                }
            });
        }
        try {
            System.out.println("await");
            countDownLatch.await();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println(LocalCache.INSTANCE.atomicInteger);
        System.out.println("size -->" + atomicInteger.get());
        System.out.println(LocalCache.INSTANCE.count);
        System.out.println(LocalCache.INSTANCE.size());
        pool.shutdown();
        try {
            Class.forName("com.bxm.warcar.aspect.mapping");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

