package com.bxm.warcar.web.autoconfigure.sentinel;

import com.bxm.warcar.cache.impls.redis.JedisFetcher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnJava;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import redis.clients.jedis.JedisPool;

/**
 * 监控探针系统redis,存放监控策略
 * <p>
 *     业务处理逻辑不应该放到基础框架里面来，该逻辑已经迁走，此处代码作废
 * </p>
 *
 * @Author kk.xie
 * @Date 2019/11/25 16:51
 * @Version 1.0
 **/
@Deprecated
@Configuration
@EnableConfigurationProperties(JedisSentinelConfiguration.class)
public class JedisSentinelAutoConfiguration {

    @Autowired
    private JedisSentinelConfiguration configuration;

    @Bean
    public JedisPool sentinelJedisPool() {
        return new JedisPool(configuration, configuration.getHost(), configuration.getPort(), configuration.getTimeout(), configuration.getPassword(), configuration.getDatabase());
    }

    @Bean
    public JedisFetcher sentinelJedisFetcher() {
        JedisFetcher jedisFetcher = new JedisFetcher(sentinelJedisPool());
        return jedisFetcher;
    }
}
