package com.bxm.warcar.web.cache.redis;

import com.bxm.warcar.cache.impls.redis.JedisFetcher;
import com.bxm.warcar.cache.impls.redis.JedisUpdater;
import com.bxm.warcar.web.cache.Cache;
import org.apache.commons.lang3.StringUtils;
import redis.clients.jedis.JedisPool;

import java.util.Map;

/**
 * <h3></h3>
 * <p></p>
 *
 * @author hcmony
 * @since V1.0.0, 2019/03/07 10:18
 */
public class RedisCache implements Cache {

    protected static final String DEFAULT_PAIR_KEY = "warcar:web:cache";

    protected  JedisPool jedisPool;
    protected  JedisFetcher jedisFetcher;
    protected  JedisUpdater jedisUpdater;
    protected  String key;

    @Override
    public String get(String key) {
       return get0(key);
    }

    @Override
    public Map<String,String> getAll() {
        return jedisFetcher.hfetchall(() -> DEFAULT_PAIR_KEY, String.class);
    }

    @Override
    public void set(String key, String value) {
        jedisUpdater.hupdate(() -> DEFAULT_PAIR_KEY, key, value);
    }

    @Override
    public void delete(String key) {
        jedisUpdater.hremove(() -> DEFAULT_PAIR_KEY, key);
    }

    public String get0(String key) {
        if (StringUtils.isBlank(key)) {
            return null;
        }
        return jedisFetcher.hfetch(() -> DEFAULT_PAIR_KEY, key, String.class);
    }
}
