/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.zk.autoconfigure;

import com.bxm.warcar.zk.ZkClientHolder;
import com.bxm.warcar.zk.autoconfigure.ZkProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@EnableConfigurationProperties(value={ZkProperties.class})
@ConditionalOnProperty(name={"warcar.zk.servers"})
public class ZkAutoConfiguration {
    private final ZkProperties properties;

    public ZkAutoConfiguration(ZkProperties properties) {
        this.properties = properties;
    }

    @Bean(initMethod="init", destroyMethod="destroy")
    public ZkClientHolder zkClientHolder() {
        return new ZkClientHolder(this.properties.getServers(), this.properties.getSessionTimeout());
    }
}

