/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.container.autoconfigure.task;

import com.bxm.warcar.container.task.TaskMetrics;
import com.google.common.base.Preconditions;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;

@Aspect
@Configuration
@ConditionalOnProperty(prefix="warcar.container", name={"enabled"}, havingValue="true")
public class TaskAspect {
    private final TaskMetrics taskMetrics;

    public TaskAspect(TaskMetrics taskMetrics) {
        Preconditions.checkNotNull((Object)taskMetrics);
        this.taskMetrics = taskMetrics;
    }

    @Around(value="@annotation(com.bxm.warcar.container.task.Task)")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        try {
            this.taskMetrics.increment();
            Object object = point.proceed();
            return object;
        }
        finally {
            this.taskMetrics.decrement();
        }
    }
}

