/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.integration.autoconfigure.message;

import com.bxm.warcar.integration.message.MessageProducer;
import com.bxm.warcar.integration.message.annotation.Messaging;
import java.lang.reflect.Method;
import javax.annotation.PreDestroy;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.annotation.Configuration;

@Aspect
@Configuration
@ConditionalOnBean(value={MessageProducer.class})
public class MessageAspect {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageAspect.class);
    private final MessageProducer messageProducer;

    public MessageAspect(MessageProducer messageProducer) {
        this.messageProducer = messageProducer;
    }

    @PreDestroy
    public void destroy() {
        this.messageProducer.getThreadPool().shutdown();
    }

    @AfterReturning(pointcut="@annotation(com.bxm.warcar.integration.message.annotation.Messaging)", returning="returning")
    public void doAfterReturning(JoinPoint point, Object returning) {
        Object[] args = point.getArgs();
        Method method = this.getMethod(point);
        if (null == method) {
            return;
        }
        if (null == returning) {
            return;
        }
        Messaging annotation = method.getAnnotation(Messaging.class);
        this.messageProducer.asyncSendMessage(args, returning, annotation);
    }

    private Method getMethod(JoinPoint point) {
        MethodSignature methodSignature = (MethodSignature)point.getSignature();
        Class<?> targetClass = point.getTarget().getClass();
        try {
            return targetClass.getMethod(methodSignature.getName(), methodSignature.getParameterTypes());
        }
        catch (NoSuchMethodException e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("getMethod:", (Throwable)e);
            }
            return null;
        }
    }

    public MessageProducer getMessageProducer() {
        return this.messageProducer;
    }
}

