package com.bxm.warcar.cache.autoconfigure.jedis;

import com.bxm.warcar.cache.impls.redis.JedisCounter;
import com.bxm.warcar.cache.impls.redis.JedisFetcher;
import com.bxm.warcar.cache.impls.redis.JedisLock;
import com.bxm.warcar.cache.impls.redis.JedisUpdater;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import redis.clients.jedis.JedisPool;

@Configuration
@EnableConfigurationProperties(JedisConfiguration.class)
public class JedisAutoConfiguration {

    @Autowired
    private JedisConfiguration configuration;

    @Bean
    public JedisPool jedisPool() {
        return new JedisPool(configuration, configuration.getHost(), configuration.getPort(), configuration.getTimeout(), configuration.getPassword(), configuration.getDatabase());
    }

    @Bean
    public JedisFetcher jedisFetcher() {
        JedisFetcher jedisFetcher = new JedisFetcher(jedisPool());
        return jedisFetcher;
    }

    @Bean
    public JedisUpdater jedisUpdater() {
        JedisUpdater jedisUpdater = new JedisUpdater(jedisPool());
        return jedisUpdater;
    }

    @Bean
    public JedisCounter jedisCounter() {
        return new JedisCounter(jedisPool());
    }

    @Bean
    public JedisLock jedisLock() {
        return new JedisLock(jedisPool());
    }
}
