/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.ip.autoconfigure;

import com.bxm.warcar.ip.IpLibrary;
import com.bxm.warcar.ip.autoconfigure.IpLibraries;
import com.bxm.warcar.ip.autoconfigure.IpLibraryConfiguration;
import com.bxm.warcar.ip.impl.BaiduIpLibrary;
import com.bxm.warcar.ip.impl.IpIpNetIpLibrary;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ClassPathResource;

@Configuration
@EnableConfigurationProperties(value={IpLibraryConfiguration.class})
public class IpLibraryAutoConfiguration {
    @Autowired
    private IpLibraryConfiguration configuration;

    @Bean(value={"baiduIpLibrary"})
    public BaiduIpLibrary baiduIpLibrary() {
        return new BaiduIpLibrary();
    }

    @Bean(name={"ipIpNetIpLibrary"}, initMethod="init", destroyMethod="destroy")
    public IpIpNetIpLibrary ipIpNetIpLibrary() {
        try {
            return new IpIpNetIpLibrary(new ClassPathResource(this.configuration.getIpipNetFilePath()).getInputStream());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Bean(value={"ipLibraries"})
    public IpLibraries ipLibraries() {
        return new IpLibraries(new IpLibrary[]{this.ipIpNetIpLibrary(), this.baiduIpLibrary()});
    }
}

