package com.bxm.user.api.controller;

import com.bxm.user.facade.DefinedRequest;
import com.bxm.user.facade.GeTuiTagsEntity;
import com.bxm.user.service.service.DevService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;

/**
 * @author 拉拉
 * @version v1.0.0
 * @fileName com.bxm.ipv6.controller.GetuiTagsController.java
 * @created 2021-05-19 16:27:00
 * @modifier 拉拉
 * @updated 2021-05-19 16:27:00
 */
@Slf4j
@RestController
@RequestMapping("/getui")
public class GetuiTagsController {

    @Autowired
    DevService devService;


    @GetMapping("/save")
    public void save(@RequestParam String uid, @RequestParam String ipv6, @RequestParam String ua, HttpServletRequest request) {
        devService.saveTagsForGetuiByParams(DefinedRequest.builder().ua(ua).ipv6(ipv6).uid(uid).build());
    }

    @GetMapping("/get")
    public GeTuiTagsEntity get(@RequestParam String uid,  HttpServletRequest request) {
       return devService.getTagsForGetuiIPV6ByUid(uid);
    }
}
