/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.user.service.facade;

import com.bxm.user.facade.DefinedRequest;
import com.bxm.user.facade.DevRequest;
import com.bxm.user.facade.GeTuiTagsEntity;
import com.bxm.user.facade.SdkInitCache;
import com.bxm.user.facade.UserProfile;
import com.bxm.user.facade.service.UserService;
import com.bxm.user.service.service.DevService;
import com.bxm.user.service.utils.DevHelper;
import com.bxm.user.service.utils.DevOsEnum;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class UserServiceImpl
implements UserService {
    private static final Logger log = LoggerFactory.getLogger(UserServiceImpl.class);
    @Autowired
    private DevService devService;

    public UserProfile getUser(@RequestBody DevRequest request) {
        UserProfile user = new UserProfile();
        user.setUid(DevHelper.getUid(request));
        return user;
    }

    public SdkInitCache getSdkInit(@RequestBody DevRequest request) {
        String uid = DevHelper.getUid(request);
        return this.getSdkInitByUid(uid);
    }

    public SdkInitCache getSdkInitByUid(String uid) {
        return this.devService.getSdkInitByUid(uid);
    }

    public List<String> getInstalledList(@RequestBody DevRequest request) {
        if (!Objects.equals(request.getOs(), DevOsEnum.ANDROID.getId())) {
            return null;
        }
        String uid = DevHelper.getUid(request);
        return this.getInstalledListByUid(uid);
    }

    public List<String> getInstalledListByUid(String uid) {
        return this.devService.getInstalledListByUid(uid);
    }

    public List<String> getTagsForGetui(@RequestBody DevRequest request) {
        String uid = DevHelper.getUid(request);
        return this.devService.getTagsForGetuiByUid(uid);
    }

    public List<String> getTagsForGetuiByUid(String uid) {
        return this.devService.getTagsForGetuiByUid(uid);
    }

    public void saveTagsForGetui(String uid, String ipv6, String ua) {
        this.devService.saveTagsForGetuiByParams(DefinedRequest.builder().uid(uid).ipv6(ipv6).ua(ua).build());
    }

    public void saveTagsForGetuiByParams(@RequestBody DevRequest request) {
        this.saveTagsForGetuiByParams2(DefinedRequest.builder().ipv6(request.getIpv6()).uid(request.getUid()).ua(request.getUa()).build());
    }

    public void saveTagsForGetuiByParams2(@RequestBody DefinedRequest request) {
        this.devService.saveTagsForGetuiByParams(request);
    }

    public List<String> getTagsForGetuiIPV6ByUid(String uid) {
        GeTuiTagsEntity geTuiTagsEntity = this.devService.getTagsForGetuiIPV6ByUid(uid);
        if (geTuiTagsEntity == null) {
            return new ArrayList<String>();
        }
        return geTuiTagsEntity.getTags();
    }
}

