/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.user.service.service.impl;

import com.bxm.user.facade.DefinedRequest;
import com.bxm.user.facade.GeTuiTagsEntity;
import com.bxm.user.facade.RedisKeyGenerator;
import com.bxm.user.facade.SdkInitCache;
import com.bxm.user.service.service.DevService;
import com.bxm.user.service.service.GetuiService;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.utils.KeyBuilder;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class DevServiceImpl
implements DevService {
    @Autowired
    @Qualifier(value="jedisFetcher")
    private Fetcher fetcher;
    @Autowired
    GetuiService getuiService;

    @Override
    public SdkInitCache getSdkInitByUid(String uid) {
        KeyGenerator keyGenerator = DevServiceImpl.getInitInfo(uid);
        return (SdkInitCache)this.fetcher.fetch(keyGenerator, SdkInitCache.class);
    }

    @Override
    public List<String> getInstalledListByUid(String uid) {
        KeyGenerator keyGenerator = DevServiceImpl.getInitInstalledList(uid);
        return (List)this.fetcher.fetch(keyGenerator, List.class);
    }

    @Override
    public List<String> getTagsForGetuiByUid(String uid) {
        return this.fetcher.fetchListWithSelector(DevServiceImpl.getTagsForGetui(uid), String.class, 5);
    }

    @Override
    public void saveTagsForGetuiByParams(DefinedRequest request) {
        this.getuiService.save(request);
    }

    @Override
    public GeTuiTagsEntity getTagsForGetuiIPV6ByUid(String uid) {
        return (GeTuiTagsEntity)this.fetcher.fetchWithSelector(RedisKeyGenerator.getTagsForGetuiIpV6((String)uid), GeTuiTagsEntity.class, 5);
    }

    public static KeyGenerator getInitInfo(String devNo) {
        return () -> KeyBuilder.build((Object[])new Object[]{"ADX", "SDK", "INIT", "devNo", devNo});
    }

    public static KeyGenerator getInitInstalledList(String devNo) {
        return () -> KeyBuilder.build((Object[])new Object[]{"ADX", "SDK", "INIT", "devNo", devNo, "APPS"});
    }

    public static KeyGenerator getTagsForGetui(String devNo) {
        return () -> KeyBuilder.build((Object[])new Object[]{"tmp", "getui", "tags", devNo});
    }
}

