/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.user.service.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.annotation.JSONField;
import com.bxm.user.facade.DefinedRequest;
import com.bxm.user.facade.GeTuiTagsEntity;
import com.bxm.user.facade.RedisKeyGenerator;
import com.bxm.user.facade.config.LogsUrlConfiguration;
import com.bxm.user.service.config.GetuiConfig;
import com.bxm.user.service.service.DevService;
import com.bxm.user.service.service.GetuiService;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.http.HttpClientUtils;
import com.bxm.warcar.utils.http.OkHttpUtils;
import com.bxm.warcar.xcache.Fetcher;
import com.bxm.warcar.xcache.TargetFactory;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GetuiServiceImpl
implements GetuiService,
MeterBinder {
    private static final Logger log = LoggerFactory.getLogger(GetuiServiceImpl.class);
    @Autowired
    DevService devService;
    private final Fetcher fetcher;
    private final Updater updater;
    private CloseableHttpClient httpClient;
    private MeterRegistry registry;
    private Timer timer;
    private Map<String, Counter> failOnType = Maps.newConcurrentMap();
    @Autowired
    LogsUrlConfiguration logsUrlConfiguration;

    public GetuiServiceImpl(Fetcher fetcher, Updater updater) {
        this.fetcher = fetcher;
        this.updater = updater;
        SocketConfig socketConfig = SocketConfig.custom().setTcpNoDelay(true).build();
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(5000L, TimeUnit.MILLISECONDS);
        connectionManager.setDefaultSocketConfig(socketConfig);
        connectionManager.setDefaultMaxPerRoute(250);
        connectionManager.setMaxTotal(3000);
        connectionManager.setValidateAfterInactivity(5000);
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(200).setConnectTimeout(30).setConnectionRequestTimeout(10).setStaleConnectionCheckEnabled(true).build();
        this.httpClient = HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).setConnectionManager((HttpClientConnectionManager)connectionManager).build();
    }

    @Override
    public void save(DefinedRequest devRequest) {
        if (StringUtils.isEmpty((String)devRequest.getUid()) || StringUtils.isEmpty((String)devRequest.getIpv6())) {
            return;
        }
        try {
            GeTuiTagsEntity geTuiTagsEntity = this.devService.getTagsForGetuiIPV6ByUid(devRequest.getUid());
            List<Object> tagsList = new ArrayList();
            GetuiRequest request = this.ofEndpoint(devRequest);
            Boolean isUpdateRedis = false;
            if (geTuiTagsEntity == null) {
                isUpdateRedis = true;
                tagsList = this.fetchTags(request);
            } else {
                int value;
                int n = value = geTuiTagsEntity.getLastDate() != null ? (int)(LocalDate.now().toEpochDay() - geTuiTagsEntity.getLastDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate().toEpochDay()) : 8;
                if (value > 7) {
                    isUpdateRedis = true;
                    tagsList = this.fetchTags(request);
                }
            }
            if (isUpdateRedis.booleanValue()) {
                geTuiTagsEntity = new GeTuiTagsEntity();
                geTuiTagsEntity.setLastDate(new Date());
                geTuiTagsEntity.setIpV6(devRequest.getIpv6());
                geTuiTagsEntity.setTags(tagsList);
                geTuiTagsEntity.setUid(devRequest.getUid());
                this.updater.updateWithSelector(RedisKeyGenerator.getTagsForGetuiIpV6((String)devRequest.getUid()), (Object)geTuiTagsEntity, 2678400, 5);
                geTuiTagsEntity.setUa(devRequest.getUa());
                this.sendTagsToData(geTuiTagsEntity);
            }
        }
        catch (Exception e) {
            log.error("save getui tags error ", (Throwable)e);
        }
    }

    public void sendTagsToData(GeTuiTagsEntity geTuiTagsEntity) {
        try {
            HashMap params = Maps.newHashMap();
            params.put("requestBody", JSON.toJSONString((Object)geTuiTagsEntity));
            this.get(this.logsUrlConfiguration.getBigDataTagsUrl(), params, null);
        }
        catch (Exception e) {
            log.error("send tags eror ", (Throwable)e);
        }
    }

    private GetuiRequest ofEndpoint(DefinedRequest devRequest) {
        return GetuiRequest.builder().ipv6(devRequest.getIpv6()).ipv6MD5(DigestUtils.md5Hex((String)devRequest.getIpv6())).ua(devRequest.getUa()).cookieId(devRequest.getUid()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> fetchTags(GetuiRequest request) {
        long start = System.nanoTime();
        GetuiConfig config = new GetuiConfig();
        String url = config.getFetchTagUrl();
        HashMap headers = Maps.newHashMap();
        headers.put("Authorization", "Bearer " + this.getAccessCode());
        headers.put("Accept", "application/vnd.dmp.v1+json");
        try {
            String body = this.postRequestBody(url, request, headers);
            if (StringUtils.isNotBlank((String)body)) {
                GetuiResponse response = (GetuiResponse)JsonHelper.convert((String)body, GetuiResponse.class);
                List<String> list = response.getData();
                return list;
            }
        }
        catch (Exception e) {
            String message = e.getClass().getSimpleName();
            Counter counter = this.failOnType.get(message);
            if (Objects.isNull(counter)) {
                counter = Counter.builder((String)"getui.fail").tags(new String[]{"type", message}).register(this.registry);
                this.failOnType.put(message, counter);
            }
            counter.increment();
        }
        finally {
            if (Objects.nonNull(this.timer)) {
                this.timer.record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
            }
        }
        return Lists.newArrayList();
    }

    private String getAccessCode() {
        return (String)this.fetcher.fetch(new TargetFactory().keyGenerator(RedisKeyGenerator.getGetuiIpV6Token()).skipNativeCache(false).cls(String.class).expireTimeInSecond(7000).selector(5).dataExtractor(() -> {
            GetuiConfig getui = new GetuiConfig();
            String userCode = getui.getUserCode();
            String authCode = getui.getAuthCode();
            String authUrl = getui.getAuthUrl();
            String timestamp = String.valueOf(System.currentTimeMillis());
            HashMap params = Maps.newHashMap();
            params.put("user_code", userCode);
            params.put("sign1", DigestUtils.md5Hex((String)(userCode + DigestUtils.md5Hex((String)timestamp))));
            params.put("sign2", DigestUtils.md5Hex((String)(userCode + authCode + DigestUtils.md5Hex((String)timestamp))));
            params.put("timestamp", timestamp);
            HashMap headers = Maps.newHashMap();
            try {
                String body = this.get(authUrl, params, headers);
                if (StringUtils.isNotBlank((String)body)) {
                    GetuiAccessResponse response = (GetuiAccessResponse)JsonHelper.convert((String)body, GetuiAccessResponse.class);
                    return response.getAccessToken();
                }
            }
            catch (Exception e) {
                log.warn("getAccessCode: ", (Throwable)e);
            }
            return null;
        }).build());
    }

    private String get(String url, Map<String, Object> params, Map<String, String> headers) throws IOException {
        HttpGet httpGet = new HttpGet(OkHttpUtils.appendParams((String)url, params));
        HttpClientUtils.setHeader((HttpRequestBase)httpGet, headers);
        return this.doRequest((HttpRequestBase)httpGet, headers);
    }

    private String postRequestBody(String url, Object o, Map<String, String> headers) throws IOException {
        HttpPost httpPost = new HttpPost(url);
        HttpClientUtils.setRequestBody((HttpPost)httpPost, (Object)o);
        return this.doRequest((HttpRequestBase)httpPost, headers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String doRequest(HttpRequestBase httpReq, Map<String, String> headers) throws IOException {
        try (CloseableHttpResponse httpResp = null;){
            HttpClientUtils.setHeader((HttpRequestBase)httpReq, headers);
            httpResp = this.httpClient.execute((HttpUriRequest)httpReq);
            String string = EntityUtils.toString((HttpEntity)httpResp.getEntity());
            return string;
        }
    }

    public void bindTo(MeterRegistry registry) {
        this.registry = registry;
        this.timer = Timer.builder((String)"getui.ipV6.requests").register(registry);
    }

    private static class GetuiAccessResponse
    implements Serializable {
        private static final long serialVersionUID = -3405031987864169602L;
        private String code;
        @JSONField(name="access_token")
        private String accessToken;
        @JSONField(name="expires_in")
        private Long expiresIn;

        public String getCode() {
            return this.code;
        }

        public String getAccessToken() {
            return this.accessToken;
        }

        public Long getExpiresIn() {
            return this.expiresIn;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        public void setExpiresIn(Long expiresIn) {
            this.expiresIn = expiresIn;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GetuiAccessResponse)) {
                return false;
            }
            GetuiAccessResponse other = (GetuiAccessResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$code = this.getCode();
            String other$code = other.getCode();
            if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
                return false;
            }
            String this$accessToken = this.getAccessToken();
            String other$accessToken = other.getAccessToken();
            if (this$accessToken == null ? other$accessToken != null : !this$accessToken.equals(other$accessToken)) {
                return false;
            }
            Long this$expiresIn = this.getExpiresIn();
            Long other$expiresIn = other.getExpiresIn();
            return !(this$expiresIn == null ? other$expiresIn != null : !((Object)this$expiresIn).equals(other$expiresIn));
        }

        protected boolean canEqual(Object other) {
            return other instanceof GetuiAccessResponse;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $code = this.getCode();
            result = result * 59 + ($code == null ? 43 : $code.hashCode());
            String $accessToken = this.getAccessToken();
            result = result * 59 + ($accessToken == null ? 43 : $accessToken.hashCode());
            Long $expiresIn = this.getExpiresIn();
            result = result * 59 + ($expiresIn == null ? 43 : ((Object)$expiresIn).hashCode());
            return result;
        }

        public String toString() {
            return "GetuiServiceImpl.GetuiAccessResponse(code=" + this.getCode() + ", accessToken=" + this.getAccessToken() + ", expiresIn=" + this.getExpiresIn() + ")";
        }
    }

    private static class GetuiResponse
    implements Serializable {
        private static final long serialVersionUID = 8092303601506991826L;
        private String code;
        private List<String> data = Lists.newArrayList();

        public String getCode() {
            return this.code;
        }

        public List<String> getData() {
            return this.data;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public void setData(List<String> data) {
            this.data = data;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GetuiResponse)) {
                return false;
            }
            GetuiResponse other = (GetuiResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$code = this.getCode();
            String other$code = other.getCode();
            if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
                return false;
            }
            List<String> this$data = this.getData();
            List<String> other$data = other.getData();
            return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
        }

        protected boolean canEqual(Object other) {
            return other instanceof GetuiResponse;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $code = this.getCode();
            result = result * 59 + ($code == null ? 43 : $code.hashCode());
            List<String> $data = this.getData();
            result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
            return result;
        }

        public String toString() {
            return "GetuiServiceImpl.GetuiResponse(code=" + this.getCode() + ", data=" + this.getData() + ")";
        }
    }

    private static class GetuiRequest
    implements Serializable {
        private static final long serialVersionUID = -4643729044689196299L;
        private String ipv6;
        private String ipv6MD5;
        private String cookieId;
        private String ua;

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SIMPLE_STYLE);
        }

        public static GetuiRequestBuilder builder() {
            return new GetuiRequestBuilder();
        }

        public String getIpv6() {
            return this.ipv6;
        }

        public String getIpv6MD5() {
            return this.ipv6MD5;
        }

        public String getCookieId() {
            return this.cookieId;
        }

        public String getUa() {
            return this.ua;
        }

        public void setIpv6(String ipv6) {
            this.ipv6 = ipv6;
        }

        public void setIpv6MD5(String ipv6MD5) {
            this.ipv6MD5 = ipv6MD5;
        }

        public void setCookieId(String cookieId) {
            this.cookieId = cookieId;
        }

        public void setUa(String ua) {
            this.ua = ua;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GetuiRequest)) {
                return false;
            }
            GetuiRequest other = (GetuiRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$ipv6 = this.getIpv6();
            String other$ipv6 = other.getIpv6();
            if (this$ipv6 == null ? other$ipv6 != null : !this$ipv6.equals(other$ipv6)) {
                return false;
            }
            String this$ipv6MD5 = this.getIpv6MD5();
            String other$ipv6MD5 = other.getIpv6MD5();
            if (this$ipv6MD5 == null ? other$ipv6MD5 != null : !this$ipv6MD5.equals(other$ipv6MD5)) {
                return false;
            }
            String this$cookieId = this.getCookieId();
            String other$cookieId = other.getCookieId();
            if (this$cookieId == null ? other$cookieId != null : !this$cookieId.equals(other$cookieId)) {
                return false;
            }
            String this$ua = this.getUa();
            String other$ua = other.getUa();
            return !(this$ua == null ? other$ua != null : !this$ua.equals(other$ua));
        }

        protected boolean canEqual(Object other) {
            return other instanceof GetuiRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $ipv6 = this.getIpv6();
            result = result * 59 + ($ipv6 == null ? 43 : $ipv6.hashCode());
            String $ipv6MD5 = this.getIpv6MD5();
            result = result * 59 + ($ipv6MD5 == null ? 43 : $ipv6MD5.hashCode());
            String $cookieId = this.getCookieId();
            result = result * 59 + ($cookieId == null ? 43 : $cookieId.hashCode());
            String $ua = this.getUa();
            result = result * 59 + ($ua == null ? 43 : $ua.hashCode());
            return result;
        }

        public GetuiRequest(String ipv6, String ipv6MD5, String cookieId, String ua) {
            this.ipv6 = ipv6;
            this.ipv6MD5 = ipv6MD5;
            this.cookieId = cookieId;
            this.ua = ua;
        }

        public static class GetuiRequestBuilder {
            private String ipv6;
            private String ipv6MD5;
            private String cookieId;
            private String ua;

            GetuiRequestBuilder() {
            }

            public GetuiRequestBuilder ipv6(String ipv6) {
                this.ipv6 = ipv6;
                return this;
            }

            public GetuiRequestBuilder ipv6MD5(String ipv6MD5) {
                this.ipv6MD5 = ipv6MD5;
                return this;
            }

            public GetuiRequestBuilder cookieId(String cookieId) {
                this.cookieId = cookieId;
                return this;
            }

            public GetuiRequestBuilder ua(String ua) {
                this.ua = ua;
                return this;
            }

            public GetuiRequest build() {
                return new GetuiRequest(this.ipv6, this.ipv6MD5, this.cookieId, this.ua);
            }

            public String toString() {
                return "GetuiServiceImpl.GetuiRequest.GetuiRequestBuilder(ipv6=" + this.ipv6 + ", ipv6MD5=" + this.ipv6MD5 + ", cookieId=" + this.cookieId + ", ua=" + this.ua + ")";
            }
        }
    }
}

