package com.bxm.user.facade;


import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.utils.KeyBuilder;

/**
 * 所有的redisKey
 *
 * @author 拉拉
 * @version v1.0.0
 * @created 2021-05-19 17:33:00
 */
public interface RedisKeyGenerator {


    /**
     * 用户标签(个推)(根据ipV6获取的个推标签)
     */
    public static KeyGenerator getTagsForGetuiIpV6(String uid) {
        return () -> KeyBuilder.build("tmp", "getui","ipv6", "tags", uid);
    }

    /**
     * token
     * @return
     */
    public static KeyGenerator getGetuiIpV6Token() {
        return () -> KeyBuilder.build("tmp", "getui", "access_token");
    }
}
