/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.vision.data.sdk.interceptor;

import com.alibaba.fastjson.JSONObject;
import com.bxm.vision.data.sdk.WebProperties;
import com.bxm.vision.data.sdk.autoconfigure.DotSupport;
import com.bxm.warcar.cache.impls.redis.JedisFetcher;
import com.bxm.warcar.cache.impls.redis.JedisUpdater;
import com.bxm.warcar.integration.dc.dot.DotParameter;
import com.bxm.warcar.integration.dc.dot.DotParameterFactory;
import com.bxm.warcar.integration.dc.dot.ModelTypeEnum;
import com.bxm.warcar.utils.IpHelper;
import com.bxm.warcar.utils.KeyBuilder;
import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class IpInterceptor
implements HandlerInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(IpInterceptor.class);
    private static final String RESPONSE_MODEL = "\",\"success\":true,\"error\":false,\"code\":1,\"message\":\"ip\"}";
    private static final String UID = "uid";
    private static final String APPKEY = "appkey";
    private static final String COUNTID = "countId";
    private static final String BUSINESS = "business";
    private static final String CLICK_HEAD = "clickMsg";
    private static final int CLICK_DB_INDEX = 11;
    private static final int CLICK_EXPIRE = 259200;
    private final WebProperties webProperties;
    private final JedisFetcher sentinelJedisFetcher;
    private final JedisFetcher visionJedisFetcher;
    private final DotSupport dotSupport;
    private final JedisUpdater jedisUpdater;
    private final JedisFetcher jedisFetcher;

    public IpInterceptor(JedisFetcher sentinelJedisFetcher, JedisFetcher visionJedisFetcher, WebProperties webProperties, DotSupport dotSupport, JedisUpdater jedisUpdater, JedisFetcher jedisFetcher) {
        this.webProperties = webProperties;
        this.sentinelJedisFetcher = sentinelJedisFetcher;
        this.visionJedisFetcher = visionJedisFetcher;
        this.dotSupport = dotSupport;
        this.jedisUpdater = jedisUpdater;
        this.jedisFetcher = jedisFetcher;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        try {
            String business;
            if (!this.isOpenFilter()) {
                return true;
            }
            if (this.ignore(request)) {
                return true;
            }
            String ip = StringUtils.defaultIfEmpty((String)IpHelper.getIpFromHeader((HttpServletRequest)request), (String)"");
            String uid = StringUtils.defaultIfEmpty((String)this.getValue(request, UID), (String)"");
            boolean cheatIp = this.checkIpCheat(ip);
            boolean cheatUid = this.checkUidCheat(uid);
            if (!cheatIp && !cheatUid) {
                return true;
            }
            String appkey = StringUtils.defaultIfEmpty((String)this.getValue(request, APPKEY), (String)"");
            boolean monitorPosition = this.checkMonitorPosition(appkey, business = StringUtils.defaultIfEmpty((String)this.getValue(request, BUSINESS), (String)""), cheatIp, cheatUid);
            if (monitorPosition) {
                return true;
            }
            HashMap map = Maps.newHashMap();
            this.banned(map, cheatIp, cheatUid);
            String countid = this.getValue(request, COUNTID);
            String modeltype = this.getValue(request, "modeltype");
            if (StringUtils.isNotBlank((String)modeltype)) {
                this.setBxmId(request, ip, appkey, business, countid, modeltype);
                this.dotSupport.asyncDoGet(request, map);
            } else {
                this.asyncDoGetEffect(request, map);
            }
            this.write(response, countid);
            return false;
        }
        catch (Exception e) {
            LOGGER.error(" Resolving IP exceptions !", (Throwable)e);
            return true;
        }
    }

    void asyncDoGetEffect(HttpServletRequest request, Map<String, String> map) {
        JSONObject json = this.fill(request);
        String modeltype = this.getValue(request, json, "modeltype");
        if (StringUtils.isBlank((String)modeltype) || !"7".equals(modeltype)) {
            return;
        }
        String bxm_id = this.getValue(request, json, "bxm_id");
        DotParameterFactory parameterFactory = DotParameterFactory.create().bxmid(bxm_id).modelType(modeltype).mt(ModelTypeEnum._1).status(this.getValue(request, json, "status")).sh(json.getInteger("sh")).sw(json.getInteger("sw")).ts(json.getLong("ts")).locaurl(this.getValue(request, json, "locaurl")).referrer(request.getHeader("referrer"));
        String result = (String)this.jedisFetcher.fetchWithSelector(() -> KeyBuilder.build((Object[])new Object[]{CLICK_HEAD, bxm_id}), String.class, 11);
        if (StringUtils.isNotBlank((String)result)) {
            String[] results = result.split(":");
            try {
                parameterFactory.ip(results[0]);
                parameterFactory.appkey(results[1]);
                parameterFactory.business(results[2]);
                parameterFactory.activityId((Object)results[3]);
                parameterFactory.awardId((Object)results[4]);
                parameterFactory.uid(results[5]);
                parameterFactory.assetsId((Object)results[6]);
                parameterFactory.ua(results[8]);
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
            }
        }
        DotParameter parameter = parameterFactory.build();
        parameter.put((Object)"fmModelId", (Object)request.getParameter("fmModelId"));
        parameter.put((Object)"banned", (Object)map.get("banned"));
        parameter.put((Object)"did", (Object)request.getParameter("did"));
        this.dotSupport.asyncDoGetEffect(parameter);
    }

    String getValue(HttpServletRequest request, JSONObject jsonObject, String key) {
        String value = request.getParameter(key);
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)value)) {
            return value;
        }
        return jsonObject.getString(key);
    }

    JSONObject fill(HttpServletRequest request) {
        JSONObject jsonObject = new JSONObject();
        StringBuilder sb = new StringBuilder();
        try (BufferedReader reader = request.getReader();){
            int len;
            char[] buff = new char[1024];
            while ((len = reader.read(buff)) != -1) {
                sb.append(buff, 0, len);
            }
        }
        catch (IOException e) {
            LOGGER.error("fill error ", (Throwable)e);
            return jsonObject;
        }
        String params = sb.toString();
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)params)) {
            jsonObject = JSONObject.parseObject((String)params);
        }
        return jsonObject;
    }

    private void setBxmId(HttpServletRequest request, String ip, String appkey, String business, String countid, String modeltype) {
        if (!"7".equals(modeltype)) {
            return;
        }
        String value = KeyBuilder.build((Object[])new Object[]{ip, appkey, business, this.getValue(request, "activityid"), this.getValue(request, "preid"), this.getValue(request, UID), this.getValue(request, "assetsId"), this.getValue(request, "appos"), this.getValue(request, "ua")});
        this.jedisUpdater.updateWithSelector(() -> KeyBuilder.build((Object[])new Object[]{CLICK_HEAD, countid}), (Object)value, 259200, 11);
    }

    private boolean ignore(HttpServletRequest request) {
        WebProperties.Ip ip = this.webProperties.getIp();
        if (null == ip) {
            return false;
        }
        Map<String, Set<String>> ignoreParameters = ip.getIgnoreParameters();
        if (MapUtils.isNotEmpty(ignoreParameters)) {
            for (Map.Entry<String, Set<String>> entry : ignoreParameters.entrySet()) {
                String key = entry.getKey();
                String pvalue = request.getParameter(key);
                if (!entry.getValue().contains(pvalue)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkMonitorPosition(String appkey, String business, boolean cheatIp, boolean cheatUid) {
        PositionMonitorBo all;
        String position = appkey + business.replaceAll("money|ad", "");
        if (StringUtils.isBlank((String)position)) {
            return false;
        }
        PositionMonitorBo positionMonitorBo = (PositionMonitorBo)this.sentinelJedisFetcher.hfetch(() -> "AD:CHEAT:MONITOR:POSITION", position, PositionMonitorBo.class);
        if (Objects.nonNull(positionMonitorBo)) {
            Set monitorGranularitySet = positionMonitorBo.getSet(MonitorEnum.MONITOR_GRANULARITY);
            if (monitorGranularitySet.contains("IP") && cheatIp) {
                return true;
            }
            if (monitorGranularitySet.contains("UID") && cheatUid) {
                return true;
            }
        }
        if (Objects.nonNull(all = (PositionMonitorBo)this.sentinelJedisFetcher.hfetch(() -> "AD:CHEAT:MONITOR:POSITION", "ALL", PositionMonitorBo.class))) {
            Set<MonitorEnum> processMode = all.getProcessMode();
            if (CollectionUtils.isEmpty(processMode)) {
                return false;
            }
            if (processMode.size() == 1 && processMode.contains((Object)MonitorEnum.MONITOR_GRANULARITY)) {
                return false;
            }
            Set monitorGranularitySet = all.getSet(MonitorEnum.MONITOR_GRANULARITY);
            if (monitorGranularitySet.contains("IP") && cheatIp) {
                return true;
            }
            if (monitorGranularitySet.contains("UID") && cheatUid) {
                return true;
            }
        }
        return false;
    }

    private boolean checkUidCheat(String uid) {
        return StringUtils.isNotBlank((String)uid) && Objects.nonNull(this.visionJedisFetcher.fetch(() -> StringUtils.join((Object[])new String[]{"CHEAT", "UID", uid}, (String)":"), Object.class));
    }

    private boolean checkIpCheat(String ip) {
        return StringUtils.isNotBlank((String)ip) && Objects.nonNull(this.visionJedisFetcher.fetch(() -> StringUtils.join((Object[])new String[]{"CHEAT", "IP", ip}, (String)":"), Object.class));
    }

    private String getValue(HttpServletRequest request, String key) {
        String value = request.getParameter(key);
        return value;
    }

    private boolean isOpenFilter() {
        Boolean isOpenFilter = (Boolean)this.sentinelJedisFetcher.fetch(() -> "AD:CHEAT:FLOW:FILTER:OPTION", Boolean.class);
        return Boolean.TRUE.equals(isOpenFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(HttpServletResponse response, String data) {
        PrintWriter writer = null;
        try {
            writer = response.getWriter();
            response.setStatus(200);
            writer.print("{\"data\":\"" + data + RESPONSE_MODEL);
            writer.flush();
        }
        catch (IOException e) {
            LOGGER.error(" Resolving IP write !", (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Writer)writer);
        }
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
    }

    private void banned(Map<String, String> map, boolean cheatIp, boolean cheatUid) {
        if (cheatIp) {
            map.put("banned", "1");
        }
        if (cheatUid) {
            map.put("banned", "2");
        }
        if (cheatIp && cheatUid) {
            map.put("banned", "3");
        }
    }

    static enum MonitorEnum {
        TICKET_ID,
        ACCOUNT_TYPE,
        BACK_TICKET,
        MONITOR_GRANULARITY;

    }

    static class PositionMonitorBo
    implements Serializable {
        private static final String IP = "IP";
        private static final String UID = "UID";
        private static final long serialVersionUID = -2150559929809588794L;
        private boolean ticketNotLimit;
        private final Set<MonitorEnum> processMode = new HashSet<MonitorEnum>();
        private final Map<MonitorEnum, Set> map = new HashedMap();

        public PositionMonitorBo() {
            MonitorEnum[] monitorEnums;
            for (MonitorEnum monitorEnum : monitorEnums = MonitorEnum.values()) {
                this.map.put(monitorEnum, new HashSet());
            }
        }

        public Set getSet(MonitorEnum monitorEnum) {
            return this.map.get((Object)monitorEnum);
        }

        public void removeSet(MonitorEnum monitorEnum) {
            this.map.remove((Object)monitorEnum);
            this.processMode.remove((Object)monitorEnum);
        }

        public void removeAllMonitorSet() {
            MonitorEnum[] values;
            for (MonitorEnum value : values = MonitorEnum.values()) {
                if (MonitorEnum.MONITOR_GRANULARITY.equals((Object)value)) continue;
                this.map.remove((Object)value);
                this.processMode.remove((Object)value);
            }
        }

        public void removeAllSet() {
            MonitorEnum[] values;
            for (MonitorEnum value : values = MonitorEnum.values()) {
                this.map.remove((Object)value);
                this.processMode.remove((Object)value);
            }
        }

        public boolean add(MonitorEnum monitorEnum, Object obj) {
            if (Objects.isNull(obj)) {
                return true;
            }
            HashSet<Object> set = this.map.get((Object)monitorEnum);
            if (Objects.isNull(set)) {
                set = new HashSet<Object>();
            }
            this.processMode.add(monitorEnum);
            set.add(obj);
            return true;
        }

        public boolean addAll(MonitorEnum monitorEnum, Collection collection) {
            if (CollectionUtils.isEmpty((Collection)collection)) {
                return true;
            }
            HashSet set = this.map.get((Object)monitorEnum);
            if (Objects.isNull(set)) {
                set = new HashSet();
            }
            this.processMode.add(monitorEnum);
            set.addAll(collection);
            return true;
        }

        public boolean isTicketNotLimit() {
            return this.ticketNotLimit;
        }

        public void setTicketNotLimit(boolean ticketNotLimit) {
            this.ticketNotLimit = ticketNotLimit;
        }

        public Set<MonitorEnum> getProcessMode() {
            return this.processMode;
        }

        public Map<MonitorEnum, Set> getMap() {
            return this.map;
        }
    }
}

