package com.bxm.vision.engine.facade;

import com.bxm.vision.engine.facade.model.EngineDto;
import com.bxm.warcar.utils.response.ResponseModel;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

/**
 * 引擎执行api,提供调度使用
 *
 * @ClassName EngineFeignClientService
 * @CopyRright (c) 2018-bxm：杭州微财网络科技有限公司
 * @Author kk.xie
 * @Date 2018/12/26 15:51
 * @Version 1.0
 * @Modifier kk.xie
 * @Modify Date 2018/12/26 15:51
 **/
@FeignClient("engine-service")
public interface EngineFeignClientService {
    /**
     * 执行规则
     *
     * @param engineDto
     * @return com.bxm.warcar.utils.response.ResponseModel<java.lang.Boolean>
     * @throws
     * @author kk.xie
     * @date 2018/12/27 15:50
     */
    @RequestMapping(value = "/engine/execute", method = RequestMethod.POST)
    ResponseModel<Boolean> executeScript(@RequestBody EngineDto engineDto);
}
