package com.bxm.vision.engine.facade;

import com.bxm.vision.engine.facade.model.ResourcesBo;
import com.bxm.vision.engine.facade.model.StrategyBo;
import com.bxm.warcar.utils.response.ResponseModel;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

/**
 * 引擎协调调度中心
 *
 * @Author kk.xie
 * @Date 2019/12/20 14:02
 * @Version 1.0
 **/
@FeignClient("engine-regulation")
public interface EngineRegulationFeignClientService {
    /**
     *  提交待执行的任务到引擎执行协调中心
     *
     * @param strategyBo
     * @return com.bxm.warcar.utils.response.ResponseModel<java.lang.Boolean>
     * @author kk.xie
     * @date 2019/12/20 14:05
     */
    @RequestMapping(value = "/submit", method = RequestMethod.POST)
    ResponseModel<Boolean> submit(@RequestBody StrategyBo strategyBo);

    /**
     * TYPE=获取，返回获取的IP及端口
     * TYPE=释放，返回是否成功
     * TYPE=新增，返回是否成功
     *
     * @param resourcesBo
     * @return com.bxm.warcar.utils.response.ResponseModel<com.bxm.vision.engine.facade.model.ResourcesBo>
     * @author kk.xie
     * @date 2019/12/20 17:11
     */
    @RequestMapping(value = "/resources", method = RequestMethod.POST)
    ResponseModel<ResourcesBo> resources(@RequestBody ResourcesBo resourcesBo);
}
