package com.bxm.vision.engine.facade;

import com.bxm.vision.engine.facade.model.ExecutorBo;
import com.bxm.vision.engine.facade.model.RulerBo;
import com.bxm.warcar.utils.response.ResponseModel;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

/**
 * 执行器对外服务
 *
 * @Author kk.xie
 * @Date 2019/12/23 14:32
 * @Version 1.0
 **/
@FeignClient("engine-executor")
public interface ExecutorFeignClientService {
    /**
     * 返回规则下各集合/表的字段集合及在各自表中的数据量
     *
     * @param rulerBo
     * @return com.bxm.warcar.utils.response.ResponseModel<java.util.List<com.bxm.vision.engine.facade.model.RulerBo>>
     * @author kk.xie
     * @date 2019/12/23 14:42
     */
    @RequestMapping(value = "/executor/checkRulerResultTotal", method = RequestMethod.POST)
    ResponseModel<ExecutorBo> checkRulerResultTotal(@RequestBody RulerBo rulerBo);

    /**
     * 执行规则-dot
     *
     * @param rulerBo
     * @return com.bxm.warcar.utils.response.ResponseModel<java.lang.Boolean>
     * @author kk.xie
     * @date 2019/12/24 10:34
     */
    @RequestMapping(value = "/executor/executeDot", method = RequestMethod.POST)
    ResponseModel<Boolean> executeDot(@RequestBody RulerBo rulerBo);
    /**
     * 执行规则-detail
     *
     * @param rulerBo
     * @return com.bxm.warcar.utils.response.ResponseModel<java.lang.Boolean>
     * @author kk.xie
     * @date 2020/1/7 19:09
     */
    @RequestMapping(value = "/executor/executeDetail", method = RequestMethod.POST)
    ResponseModel<Boolean> executeDetail(@RequestBody RulerBo rulerBo);
    /**
     * 执行规则-merge
     *
     * @param rulerBo
     * @return com.bxm.warcar.utils.response.ResponseModel<java.lang.Boolean>
     * @author kk.xie
     * @date 2020/1/7 19:09
     */
    @RequestMapping(value = "/executor/executeMerge", method = RequestMethod.POST)
    ResponseModel<Boolean> executeMerge(@RequestBody RulerBo rulerBo);

    /**
     * 获取执行的sql，根据环节动态获取统计或者查询sql语句
     *
     * @param rulerBo
     * @return com.bxm.warcar.utils.response.ResponseModel<java.lang.String>
     * @author kk.xie
     * @date 2020/1/10 10:26
     */
    @RequestMapping(value = "/executor/getSql", method = RequestMethod.POST)
    ResponseModel<String> getSql(@RequestBody RulerBo rulerBo);
}
