package com.bxm.vision.engine.facade;

import com.bxm.vision.engine.facade.model.JobDto;
import com.bxm.warcar.utils.response.ResponseModel;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

/**
 * 任务执行api，提供manager使用
 *
 * @ClassName JobFeignClientService
 * @CopyRright (c) 2018-bxm：杭州微财网络科技有限公司
 * @Author kk.xie
 * @Date 2018/12/21 17:35
 * @Version 1.0
 * @Modifier kk.xie
 * @Modify Date 2018/12/21 17:35
 **/
@FeignClient("engine-schedule")
public interface JobFeignClientService {
    /**
     * 启动任务
     *
     * @param jobDto 绑定的是一组任务
     * @return com.bxm.warcar.utils.response.ResponseModel<java.lang.Boolean>
     * @throws
     * @author kk.xie
     * @date 2018/12/25 11:12
     */
    @RequestMapping(value = "/job/start", method = RequestMethod.POST)
    ResponseModel<Boolean> startTask(@RequestBody JobDto jobDto);

    /**
     * 停止任务
     *
     * @param jobDto 绑定的是一组任务
     * @return com.bxm.warcar.utils.response.ResponseModel<java.lang.Boolean>
     * @throws
     * @author kk.xie
     * @date 2018/12/25 10:52
     */
    @RequestMapping(value = "/job/stop", method = RequestMethod.POST)
    ResponseModel<Boolean> stopTask(@RequestBody JobDto jobDto);

    /**
     * 重启任务
     *
     * @param jobDto 绑定的是一组任务
     * @return com.bxm.warcar.utils.response.ResponseModel<java.lang.Boolean>
     * @throws
     * @author kk.xie
     * @date 2018/12/25 10:52
     */
    @RequestMapping(value = "/job/restart", method = RequestMethod.POST)
    ResponseModel<Boolean> restartTask(@RequestBody JobDto jobDto);

    /**
     * 重启规则任务
     *
     * @param jobDto 绑定的是任务下的一条规则
     * @return com.bxm.warcar.utils.response.ResponseModel<java.lang.Boolean>
     * @throws
     * @author kk.xie
     * @date 2018/12/25 10:52
     */
    @RequestMapping(value = "/job/ruler/restart", method = RequestMethod.POST)
    ResponseModel<Boolean> restartRuler(@RequestBody JobDto jobDto);
    /**
     * 启动规则
     *
     * @param jobDto
     * @return com.bxm.warcar.utils.response.ResponseModel<java.lang.Boolean>
     * @throws
     * @author kk.xie
     * @date 2019/5/15 16:59
     */
    @RequestMapping(value = "/job/ruler/start", method = RequestMethod.POST)
    ResponseModel<Boolean> startRuler(@RequestBody JobDto jobDto);
    /**
     * 停止规则
     *
     * @param jobDto
     * @return com.bxm.warcar.utils.response.ResponseModel<java.lang.Boolean>
     * @throws
     * @author kk.xie
     * @date 2019/5/15 16:59
     */
    @RequestMapping(value = "/job/ruler/stop", method = RequestMethod.POST)
    ResponseModel<Boolean> stopRuler(@RequestBody JobDto jobDto);

    /**
     * 立即执行任务
     *
     * @param jobDto
     * @return com.bxm.warcar.utils.response.ResponseModel<java.lang.String>
     * @throws
     * @author kk.xie
     * @date 2019/3/21 11:29
     */
    @RequestMapping(value = "/job/executeNow", method = RequestMethod.POST)
    ResponseModel<String> executeNow(@RequestBody JobDto jobDto);

   /**
    * 规则测试执行
    *
    * @param jobDto
    * @return com.bxm.warcar.utils.response.ResponseModel<java.lang.String>
    * @throws
    * @author kk.xie
    * @date 2019/8/12 14:36
    */
    @RequestMapping(value = "/job/testExecute", method = RequestMethod.POST)
    ResponseModel<Boolean> testExecute(@RequestBody JobDto jobDto);
}
