package com.bxm.vision.engine.facade;

import com.bxm.vision.engine.facade.model.StrategyJobDto;
import com.bxm.warcar.utils.response.ResponseModel;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

/**
 * 策略执行对外服务
 *
 * @Author kk.xie
 * @Date 2019/12/19 9:48
 * @Version 1.0
 **/
@FeignClient("engine-schedule")
public interface StrategyJobFeignClientService {
    /**
     * 启动策略
     *
     * @param strategyJobDto
     * @return com.bxm.warcar.utils.response.ResponseModel<java.lang.Boolean>
     * @author kk.xie
     * @date 2019/12/19 10:33
     */
    @RequestMapping(value = "/strategy/start", method = RequestMethod.POST)
    ResponseModel<Boolean> start(@RequestBody StrategyJobDto strategyJobDto);

    /**
     * 停止策略
     *
     * @param strategyJobDto
     * @return com.bxm.warcar.utils.response.ResponseModel<java.lang.Boolean>
     * @author kk.xie
     * @date 2019/12/19 10:33
     */
    @RequestMapping(value = "/strategy/stop", method = RequestMethod.POST)
    ResponseModel<Boolean> stop(@RequestBody StrategyJobDto strategyJobDto);
    /**
     * 立即执行
     *
     * @param strategyJobDto
     * @return com.bxm.warcar.utils.response.ResponseModel<java.lang.Boolean>
     * @author kk.xie
     * @date 2020/1/15 17:38
     */
    @RequestMapping(value = "/strategy/executeNow", method = RequestMethod.POST)
    ResponseModel<Boolean> executeNow(@RequestBody StrategyJobDto strategyJobDto);
    /**
     * 策略预跑
     *
     * @param strategyJobDto
     * @return com.bxm.warcar.utils.response.ResponseModel<java.lang.Boolean>
     * @author kk.xie
     * @date 2019/12/19 10:33
     */
    @RequestMapping(value = "/strategy/test", method = RequestMethod.POST)
    ResponseModel<Boolean> test(@RequestBody StrategyJobDto strategyJobDto);

    /**
     * 规则预跑
     *
     * @param strategyJobDto
     * @return com.bxm.warcar.utils.response.ResponseModel<java.lang.Boolean>
     * @author kk.xie
     * @date 2019/12/19 10:33
     */
    @RequestMapping(value = "/strategy/ruler/test", method = RequestMethod.POST)
    ResponseModel<Boolean> rulerTest(@RequestBody StrategyJobDto strategyJobDto);
}
